/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestDoubleQueue<V> {
    private LinkedList<V> queue1;
    private LinkedList<V> queue2;
    private int capacity1;
    private int capacity2;

    public RequestDoubleQueue(int capacity1, int capacity2) {
        this.capacity1 = capacity1;
        this.capacity2 = capacity2;
        this.queue1 = new LinkedList();
        this.queue2 = new LinkedList();
    }

    public synchronized V get() {
        while (this.queue1.size() <= 0 && this.queue2.size() <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.queue1.size() > 0) {
            return this.queue1.removeFirst();
        }
        if (this.queue2.size() > 0) {
            return this.queue2.removeFirst();
        }
        return null;
    }

    public synchronized V getNoWait() {
        if (this.queue1.size() > 0) {
            return this.queue1.removeFirst();
        }
        if (this.queue2.size() > 0) {
            return this.queue2.removeFirst();
        }
        return null;
    }

    public synchronized V get(long timeout) {
        if (this.queue1.size() > 0) {
            return this.queue1.removeFirst();
        }
        if (this.queue2.size() > 0) {
            return this.queue2.removeFirst();
        }
        long timeto = System.currentTimeMillis() + timeout;
        long time = timeout;
        while (this.queue1.isEmpty() && this.queue2.isEmpty()) {
            try {
                if (time > 0L) {
                    this.wait(time);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((time = timeto - System.currentTimeMillis()) > 0L) continue;
        }
        if (this.queue1.size() > 0) {
            return this.queue1.removeFirst();
        }
        if (this.queue2.size() > 0) {
            return this.queue2.removeFirst();
        }
        return null;
    }

    public synchronized boolean putForce1(V o) {
        return this.putForce(this.queue1, this.capacity1, o);
    }

    public synchronized boolean putForce2(V o) {
        return this.putForce(this.queue2, this.capacity2, o);
    }

    private boolean putForce(LinkedList<V> q, int sz, V o) {
        if (sz <= 0 || q.size() < this.capacity1) {
            q.add(o);
            this.notifyAll();
            return true;
        }
        while (q.size() >= sz) {
            V v = q.removeFirst();
            this.overflowed(v);
        }
        q.add(o);
        this.notifyAll();
        return false;
    }

    protected void overflowed(V v) {
    }

    protected void failed(V v) {
    }

    public synchronized boolean put1(V o) {
        return this.put(this.queue1, this.capacity1, o);
    }

    public synchronized boolean put2(V o) {
        return this.put(this.queue1, this.capacity1, o);
    }

    private boolean put(LinkedList<V> queue, int capacity, V o) {
        if (capacity <= 0 || queue.size() < capacity) {
            queue.add(o);
            this.notifyAll();
            return true;
        }
        this.failed(o);
        this.notifyAll();
        return false;
    }

    public synchronized void clear() {
        this.queue1.clear();
        this.queue2.clear();
    }

    public int size() {
        return this.queue1.size() + this.queue2.size();
    }

    public int size1() {
        return this.queue1.size();
    }

    public int size2() {
        return this.queue2.size();
    }

    public int getCapacity1() {
        return this.capacity1;
    }

    public int getCapacity2() {
        return this.capacity2;
    }

    public void setCapacity(int size1, int size2) {
        this.capacity1 = size1;
        this.capacity2 = size2;
    }
}

