/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import whatap.util.ArrayUtil;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathTree<V> {
    protected ENTRY top = new ENTRY();
    protected int count;

    public V insert(String path, V value) {
        if (StringUtil.isEmpty(path)) {
            return null;
        }
        return this.insert(StringUtil.split(path, '/'), value);
    }

    public synchronized V insert(String[] paths, V value) {
        if (ArrayUtil.isEmpty(paths) || value == null) {
            return null;
        }
        if (paths.length == 1) {
            return null;
        }
        PATH path = new PATH(paths);
        if (this.top.child == null) {
            ENTRY cur = this.top;
            cur.child = new ENTRY();
            cur.child.parent = cur;
            cur = cur.child;
            cur.node = path.node();
            ++this.count;
            return this.expand(cur, path, value);
        }
        return this.insert(this.top, this.top.child, path, value);
    }

    private V expand(ENTRY cur, PATH path, V value) {
        while (path.hasChild()) {
            ++path.level;
            cur.child = new ENTRY();
            cur.child.parent = cur;
            cur = cur.child;
            cur.node = path.node();
            ++this.count;
        }
        Object old = cur.value;
        cur.value = value;
        return old;
    }

    private V insert(ENTRY p, ENTRY cur, PATH path, V value) {
        if (path.node().equals(cur.node)) {
            if (!path.hasChild()) {
                Object old = cur.value;
                cur.value = value;
                return old;
            }
            ++path.level;
            if (cur.child != null) {
                return this.insert(cur, cur.child, path, value);
            }
            cur.child = new ENTRY();
            cur.child.parent = cur;
            cur = cur.child;
            cur.node = path.node();
            return this.expand(cur, path, value);
        }
        if (cur.right != null) {
            return this.insert(p, cur.right, path, value);
        }
        if (path.node().equals("*")) {
            cur.right = new ENTRY();
            cur.right.parent = p;
            cur = cur.right;
            cur.node = path.node();
            ++this.count;
            return this.expand(cur, path, value);
        }
        cur = new ENTRY();
        cur.parent = p;
        cur.right = p.child;
        p.child = cur;
        cur.node = path.node();
        ++this.count;
        return this.expand(cur, path, value);
    }

    public V find(String path) {
        try {
            return this.find(StringUtil.split(path, '/'));
        }
        catch (Exception e) {
            return null;
        }
    }

    public V find(String[] path) {
        if (path == null || path.length == 0) {
            return null;
        }
        try {
            return this.find(this.top.child, new PATH(path));
        }
        catch (Exception e) {
            return null;
        }
    }

    private V find(ENTRY cur, PATH m) {
        if (cur.include(m.node())) {
            if (!m.hasChild()) {
                return cur.value;
            }
            ++m.level;
            if (cur.child != null) {
                return this.find(cur.child, m);
            }
        } else if (cur.right != null) {
            return this.find(cur.right, m);
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public synchronized Enumeration<List<String>> paths() {
        return new Enumer(4);
    }

    public synchronized Enumeration<String> values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<ENTRY> entries() {
        return new Enumer(3);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{\n");
        Enumeration<ENTRY> en = this.entries();
        while (en.hasMoreElements()) {
            ENTRY e = en.nextElement();
            sb.append("    ").append(e.path() + "=>" + e.value()).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static void main(String[] args) {
        PathTree<String> t = new PathTree<String>();
        t.insert("/api/internal/v1/panels/*", "/api/internal/v1/panels/{panelNo}");
        t.insert("/api/internal/v1/panels/push", "/api/internal/v1/panels/push");
        System.out.println((String)t.find("/api/internal/v1/panels/123"));
        System.out.println((String)t.find("/api/internal/v1/panels/push"));
        System.out.println(t);
    }

    private class Enumer
    implements Enumeration {
        ENTRY entry;
        private byte type;

        Enumer(byte type) {
            this.entry = PathTree.this.top.child;
            this.type = type;
        }

        public boolean hasMoreElements() {
            return this.entry != null;
        }

        public Object nextElement() {
            if (this.entry == null) {
                throw new NoSuchElementException("no more next");
            }
            ENTRY e = this.entry;
            if (this.entry.child != null) {
                this.entry = this.entry.child;
            } else {
                while (this.entry != null && this.entry.right == null) {
                    this.entry = this.entry.parent;
                    if (this.entry != PathTree.this.top) continue;
                    this.entry = null;
                    switch (this.type) {
                        case 4: {
                            return e.path();
                        }
                        case 2: {
                            return e.value;
                        }
                    }
                    return e;
                }
                if (this.entry != null) {
                    this.entry = this.entry.right;
                }
            }
            switch (this.type) {
                case 4: {
                    return e.path();
                }
                case 2: {
                    return e.value;
                }
            }
            return e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ENTRY {
        String node;
        V value;
        ENTRY right;
        ENTRY child;
        ENTRY parent;

        public boolean include(String v) {
            return this.node.equals("*") || this.node.equals(v);
        }

        public List<String> path() {
            Stack<String> sk = new Stack<String>();
            ENTRY cur = this;
            while (cur != PathTree.this.top) {
                sk.add(cur.node);
                cur = cur.parent;
            }
            ArrayList<String> arr = new ArrayList<String>(sk.size());
            while (!sk.isEmpty()) {
                arr.add((String)sk.pop());
            }
            return arr;
        }

        public V value() {
            return this.value;
        }

        public String node() {
            return this.node;
        }
    }

    private static class PATH {
        public String[] nodes;
        public int level;

        public PATH(String[] nodes) {
            this.nodes = nodes;
        }

        public boolean hasChild() {
            return this.level + 1 < this.nodes.length;
        }

        public String node() {
            return this.nodes[this.level];
        }

        public String toString() {
            return "PATH [nodes=" + Arrays.toString(this.nodes) + ", level=" + this.level + "]";
        }
    }
}

