/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.NoSuchElementException;
import whatap.util.LongEnumer;

public class LongSet {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private LongSetity[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    public static final LongEnumer emptyEnumer = new LongEnumer(){

        public long nextLong() {
            return 0L;
        }

        public boolean hasMoreElements() {
            return false;
        }
    };

    public LongSet(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new LongSetity[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public LongSet() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized LongEnumer values() {
        return new Enumer();
    }

    public synchronized boolean contains(long value) {
        LongSetity[] buk = this.table;
        int index = LongSet.hash(value) % buk.length;
        LongSetity e = buk[index];
        while (e != null) {
            if (e.value == value) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized long get(long value) {
        LongSetity[] buk = this.table;
        int index = LongSet.hash(value) % buk.length;
        LongSetity e = buk[index];
        while (e != null) {
            if (e.value == value) {
                return e.value;
            }
            e = e.next;
        }
        return 0L;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LongSetity[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LongSetity[] newMap = new LongSetity[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            LongSetity old = oldMap[i];
            while (old != null) {
                LongSetity e = old;
                old = old.next;
                int index = LongSet.hash(e.value) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    protected static int hash(long value) {
        return (int)(value ^ value >>> 32) & Integer.MAX_VALUE;
    }

    public synchronized boolean put(long value) {
        LongSetity[] buk = this.table;
        int index = LongSet.hash(value) % buk.length;
        LongSetity e = buk[index];
        while (e != null) {
            if (e.value == value) {
                return false;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            buk = this.table;
            index = LongSet.hash(value) % buk.length;
        }
        buk[index] = e = new LongSetity(value, buk[index]);
        ++this.count;
        return true;
    }

    public boolean add(long value) {
        return this.put(value);
    }

    public synchronized long remove(long value) {
        LongSetity[] buk = this.table;
        int index = LongSet.hash(value) % buk.length;
        LongSetity e = buk[index];
        LongSetity prev = null;
        while (e != null) {
            if (e.value == value) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    buk[index] = e.next;
                }
                --this.count;
                return value;
            }
            prev = e;
            e = e.next;
        }
        return 0L;
    }

    public synchronized void clear() {
        LongSetity[] buk = this.table;
        int index = buk.length;
        while (--index >= 0) {
            buk[index] = null;
        }
        this.count = 0;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        LongEnumer it = this.values();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            long value = it.nextLong();
            buf.append(value);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public long[] toArray() {
        long[] _values = new long[this.size()];
        LongEnumer en = this.values();
        for (int i = 0; i < _values.length; ++i) {
            _values[i] = en.nextLong();
        }
        return _values;
    }

    public static class LongSetity {
        long value;
        LongSetity next;

        protected LongSetity(long value, LongSetity next) {
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new LongSetity(this.value, this.next == null ? null : (LongSetity)this.next.clone());
        }

        public long getKey() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LongSetity)) {
                return false;
            }
            LongSetity e = (LongSetity)o;
            return this.value == e.getKey();
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32) & Integer.MAX_VALUE;
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    private class Enumer
    implements LongEnumer {
        LongSetity[] table;
        int index;
        LongSetity entry;

        private Enumer() {
            this.table = LongSet.this.table;
            this.index = this.table.length;
            this.entry = null;
        }

        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public long nextLong() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                LongSetity e = this.entry;
                this.entry = e.next;
                return e.value;
            }
            throw new NoSuchElementException("no more next");
        }
    }
}

