/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.NoSuchElementException;
import whatap.util.IntEnumer;

public class IntSet {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntSetry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    public static IntEnumer emptyEnumer = new IntEnumer(){

        public int nextInt() {
            return 0;
        }

        public boolean hasMoreElements() {
            return false;
        }
    };

    public IntSet(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new IntSetry[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public IntSet() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized IntEnumer values() {
        return new Enumer();
    }

    public synchronized boolean contains(int key) {
        IntSetry[] buk = this.table;
        int index = (key & Integer.MAX_VALUE) % buk.length;
        IntSetry e = buk[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized int get(int key) {
        IntSetry[] buk = this.table;
        int index = (key & Integer.MAX_VALUE) % buk.length;
        IntSetry e = buk[index];
        while (e != null) {
            if (e.key == key) {
                return e.key;
            }
            e = e.next;
        }
        return 0;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntSetry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntSetry[] newMap = new IntSetry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            IntSetry old = oldMap[i];
            while (old != null) {
                IntSetry e = old;
                old = old.next;
                int index = (e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public void putAll(int[] values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            this.put(values[i]);
        }
    }

    public synchronized boolean put(int value) {
        IntSetry[] buk = this.table;
        int index = (value & Integer.MAX_VALUE) % buk.length;
        IntSetry e = buk[index];
        while (e != null) {
            if (e.key == value) {
                return false;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            buk = this.table;
            index = (value & Integer.MAX_VALUE) % buk.length;
        }
        buk[index] = e = new IntSetry(value, buk[index]);
        ++this.count;
        return true;
    }

    public synchronized int remove(int key) {
        IntSetry[] buk = this.table;
        int index = (key & Integer.MAX_VALUE) % buk.length;
        IntSetry e = buk[index];
        IntSetry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    buk[index] = e.next;
                }
                --this.count;
                return key;
            }
            prev = e;
            e = e.next;
        }
        return 0;
    }

    public synchronized void clear() {
        IntSetry[] buk = this.table;
        int index = buk.length;
        while (--index >= 0) {
            buk[index] = null;
        }
        this.count = 0;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        IntEnumer it = this.values();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            int key = it.nextInt();
            buf.append(key);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public int[] toArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.values();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public boolean isExistElseAdd(int value) {
        return !this.put(value);
    }

    public void putStrHash(String s) {
        if (s != null) {
            this.put(s.hashCode());
        }
    }

    private class Enumer
    implements IntEnumer {
        IntSetry[] table;
        int index;
        IntSetry entry;
        IntSetry lastReturned;

        private Enumer() {
            this.table = IntSet.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
        }

        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public int nextInt() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                IntSetry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static class IntSetry {
        int key;
        IntSetry next;

        protected IntSetry(int key, IntSetry next) {
            this.key = key;
            this.next = next;
        }

        protected Object clone() {
            return new IntSetry(this.key, this.next == null ? null : (IntSetry)this.next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntSetry)) {
                return false;
            }
            IntSetry e = (IntSetry)o;
            return this.key == e.getKey();
        }

        public int hashCode() {
            return this.key;
        }

        public String toString() {
            return Integer.toString(this.key);
        }
    }
}

