/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytesMap {
    private final Map<String, byte[]> table = new Hashtable<String, byte[]>();
    protected URLStreamHandler urlStreamHandler = new URLStreamHandler(){

        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                public void connect() throws IOException {
                }

                public InputStream getInputStream() throws IOException {
                    String name = this.getURL().getPath().substring(1);
                    byte[] b = (byte[])BytesMap.this.table.get(name);
                    if (b == null) {
                        throw new IOException("unknown bytes name : " + name);
                    }
                    return new ByteArrayInputStream(b);
                }
            };
        }
    };

    public void put(String name, byte[] data) {
        if (name == null || data == null) {
            return;
        }
        this.table.put(name, data);
    }

    public void remove(String name) {
        if (name == null) {
            return;
        }
        this.table.remove(name);
    }

    public byte[] getBytes(String name) {
        return this.table.get(name);
    }

    public List<URL> getResourceList() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (String key : this.table.keySet()) {
            urlList.add(this.getResource(key));
        }
        return urlList;
    }

    public URL getResource(String name) {
        try {
            return new URL(null, "bytes:///" + name, this.urlStreamHandler);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

