/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.sys.linux;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.ListValue;
import whatap.perfx.sys.PerfXSystem;
import whatap.util.CastUtil;
import whatap.util.DateUtil;
import whatap.util.FileUtil;
import whatap.util.HashUtil;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringLinkedSet;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxDiskIO {
    static long last_time = 0L;
    static StringKeyLinkedMap<DiskStats> last = new StringKeyLinkedMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StringKeyLinkedMap<DiskStats> process(StringLinkedSet disks) {
        StringKeyLinkedMap<DiskStats> result = new StringKeyLinkedMap<DiskStats>();
        StringKeyLinkedMap<DiskStats> curSet = new StringKeyLinkedMap<DiskStats>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader("/proc/diskstats"));
            while ((line = reader.readLine()) != null) {
                String diskName;
                String[] fields = StringUtil.tokenizer(line, " \t");
                if (fields == null || fields.length < 12 || !disks.contains(diskName = fields[2])) continue;
                DiskStats curDs = new DiskStats();
                curDs.ioTime = CastUtil.clong(fields[12]);
                curDs.sectorsRead = CastUtil.clong(fields[5]);
                curDs.sectorsWritten = CastUtil.clong(fields[9]);
                curSet.put(diskName, curDs);
                DiskStats lastDs = last.get(diskName);
                if (lastDs == null) continue;
                DiskStats delta = new DiskStats();
                delta.ioTime = curDs.ioTime - lastDs.ioTime;
                delta.sectorsRead = curDs.sectorsRead - lastDs.sectorsRead;
                delta.sectorsWritten = curDs.sectorsWritten - lastDs.sectorsWritten;
                result.put(diskName, delta);
            }
            last = curSet;
        }
        catch (Exception e) {
            try {
                Logger.println(e.toString());
            }
            catch (Throwable throwable) {
                FileUtil.close(reader);
                throw throwable;
            }
            FileUtil.close(reader);
        }
        FileUtil.close(reader);
        return result;
    }

    private static float calc(long dur, long value) {
        return (float)((double)value / (double)(dur * 100L));
    }

    public static void send(StringLinkedSet disks) {
        long now = DateUtil.nanoToMillis();
        StringKeyLinkedMap<DiskStats> result = LinuxDiskIO.process(disks);
        if (result.size() > 0) {
            TagCountPack p = new TagCountPack();
            p.time = DateUtil.currentTime() / 1000L * 1000L;
            p.category = "linux_disk_io";
            PerfXSystem.setTagAgentInfo(p);
            p.tags.put("!rectype", 2);
            ListValue idLv = p.fields.internList("@id");
            ListValue diskLv = p.fields.internList("disk");
            ListValue readLv = p.fields.internList("read");
            ListValue writeLv = p.fields.internList("write");
            ListValue busyLv = p.fields.internList("busy");
            Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<DiskStats>> en = result.entries();
            while (en.hasMoreElements()) {
                StringKeyLinkedMap.StringKeyLinkedEntry<DiskStats> ent = en.nextElement();
                idLv.add(HashUtil.hash(ent.getKey()));
                diskLv.add(ent.getKey());
                DiskStats ds = ent.getValue();
                readLv.add(ds.sectorsRead * 512L);
                writeLv.add(ds.sectorsWritten * 512L);
                busyLv.add(LinuxDiskIO.calc(now - last_time, ds.ioTime));
            }
            DataPackSender.send(p, false);
        }
        last_time = now;
    }

    static class DiskStats {
        long ioTime;
        long sectorsRead;
        long sectorsWritten;

        DiskStats() {
        }
    }
}

