/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.plugin;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import whatap.agent.Logger;
import whatap.perfx.plugin.IPerfX;
import whatap.perfx.plugin.JarLibBox;
import whatap.perfx.plugin.PerfXRun;
import whatap.util.AnsiPrint;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfXLoader {
    private static JarLibBox jarBox;
    private static List<PerfXRun> plugins;

    public static List<PerfXRun> load(String root, ClassLoader parent) {
        try {
            if (StringUtil.isEmpty(root)) {
                jarBox = null;
                plugins = null;
                return null;
            }
            File file = new File(root);
            if (!file.exists()) {
                jarBox = null;
                plugins = null;
                return null;
            }
            JarLibBox newJarBox = JarLibBox.load(root);
            if (jarBox != null && jarBox.equals(newJarBox)) {
                return plugins;
            }
            jarBox = newJarBox;
            plugins = new ArrayList<PerfXRun>();
            URLClassLoader loader = jarBox.getClassLoader(parent);
            Set<String> perfxNameSet = jarBox.getPerfXClasses();
            for (String perfxName : perfxNameSet) {
                try {
                    IPerfX perfxObject = (IPerfX)Class.forName(perfxName, true, loader).newInstance();
                    plugins.add(new PerfXRun(perfxObject));
                    Logger.yellow("PerfX load: " + perfxName);
                }
                catch (Exception e) {
                    Logger.yellow("PerfX load fail: " + perfxName + " " + e.getMessage());
                }
            }
        }
        catch (RuntimeException t) {
            Logger.yellow(AnsiPrint.red("PerfX dir=" + root + " load fail: " + t));
        }
        catch (Throwable t) {
            Logger.yellow(AnsiPrint.red("PerfX dir=" + root + " load fail: " + t));
        }
        return plugins;
    }
}

