/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.java;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.ListValue;
import whatap.perfx.java.IAction;
import whatap.perfx.java.PerfXJava;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.SystemUtil;

public class PerfXMemAction
extends IAction {
    Configure conf = Configure.getInstance();

    public void process() {
        try {
            if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
                return;
            }
            if (this.conf.tagcount_subset_v2_enabled) {
                this.javaxMemoryPool();
                this.javax_memory();
            }
            if (this.conf.tagcount_subset_v1_enabled) {
                this.memPool();
                this.memory();
            }
        }
        catch (Throwable e) {
            Logger.println(e.toString());
        }
    }

    private void memory() {
        MemoryMXBean mbs = ManagementFactory.getMemoryMXBean();
        TagCountPack p = new TagCountPack();
        p.time = DateUtil.currentTime() / 1000L * 1000L;
        p.category = "java_memory";
        PerfXJava.setTagAgentInfo(p);
        p.put("objectPendingFinalizationCount", mbs.getObjectPendingFinalizationCount());
        MemoryUsage usage = mbs.getHeapMemoryUsage();
        p.put("heap_committed", new DecimalValue(usage.getCommitted()));
        p.put("heap_init", new DecimalValue(usage.getInit()));
        p.put("heap_max", new DecimalValue(usage.getMax()));
        p.put("heap_used", new DecimalValue(usage.getUsed()));
        usage = mbs.getNonHeapMemoryUsage();
        p.put("nonheap_committed", new DecimalValue(usage.getCommitted()));
        p.put("nonheap_init", new DecimalValue(usage.getInit()));
        p.put("nonheap_max", new DecimalValue(usage.getMax()));
        p.put("nonheap_used", new DecimalValue(usage.getUsed()));
        DataPackSender.send(p);
    }

    private void javax_memory() {
        MemoryMXBean mbs = ManagementFactory.getMemoryMXBean();
        TagCountPack p = new TagCountPack();
        p.time = DateUtil.currentTime() / 1000L * 1000L;
        p.category = "javax_memory";
        p.tags.put("!rectype", 1);
        PerfXJava.setTagAgentInfo(p);
        p.put("objectPendingFinalizationCount", mbs.getObjectPendingFinalizationCount());
        MemoryUsage usage = mbs.getHeapMemoryUsage();
        p.put("heap_committed", new DecimalValue(usage.getCommitted()));
        p.put("heap_init", new DecimalValue(usage.getInit()));
        p.put("heap_max", new DecimalValue(usage.getMax()));
        p.put("heap_used", new DecimalValue(usage.getUsed()));
        usage = mbs.getNonHeapMemoryUsage();
        p.put("nonheap_committed", new DecimalValue(usage.getCommitted()));
        p.put("nonheap_init", new DecimalValue(usage.getInit()));
        p.put("nonheap_max", new DecimalValue(usage.getMax()));
        p.put("nonheap_used", new DecimalValue(usage.getUsed()));
        DataPackSender.send(p);
    }

    private void memPool() {
        List<MemoryPoolMXBean> mbs = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean mb : mbs) {
            TagCountPack p = new TagCountPack();
            p.time = DateUtil.currentTime() / 1000L * 1000L;
            p.category = "java_memory_pool";
            PerfXJava.setTagAgentInfo(p);
            MemoryUsage usage = mb.getUsage();
            p.putTag("name", mb.getName());
            p.put("committed", new DecimalValue(usage.getCommitted()));
            p.put("init", new DecimalValue(usage.getInit()));
            p.put("max", new DecimalValue(usage.getMax()));
            p.put("used", new DecimalValue(usage.getUsed()));
            DataPackSender.send(p, false);
        }
    }

    private void javaxMemoryPool() {
        TagCountPack p = new TagCountPack();
        p.time = DateUtil.currentTime() / 1000L * 1000L;
        p.category = "javax_memory_pool";
        PerfXJava.setTagAgentInfo(p);
        p.tags.put("!rectype", 2);
        ListValue idLv = p.fields.internList("@id");
        ListValue nameLv = p.fields.internList("name");
        ListValue committedLv = p.fields.internList("committed");
        ListValue initLv = p.fields.internList("init");
        ListValue maxLv = p.fields.internList("max");
        ListValue usedLv = p.fields.internList("used");
        List<MemoryPoolMXBean> mbs = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean mb : mbs) {
            MemoryUsage usage = mb.getUsage();
            String name = mb.getName();
            idLv.add(HashUtil.hash(name));
            nameLv.add(name);
            committedLv.add(usage.getCommitted());
            initLv.add(usage.getInit());
            maxLv.add(usage.getMax());
            usedLv.add(usage.getUsed());
        }
        DataPackSender.send(p, false);
    }
}

