/*
 * Decompiled with CFR 0.152.
 */
package whatap.net;

public class NetFlag {
    public static final byte SECURE_HIDE = 1;
    public static final byte SECURE_CYPHER = 2;
    public static final byte ONE_WAY_NO_CYPHER = 4;
    public static final byte ROUTER_HANDLE = 8;
    public static final byte RESERVED3 = 16;
    public static final byte RESERVED4 = 32;
    public static final byte RESERVED5 = 64;
    public static final byte RESERVED6 = -128;
    public static final byte WS_ASK_SYSID = -7;
    public static final byte MASTER_SELECTION = -6;
    public static final byte ACK = -5;
    public static final byte PREPARE_AGENT = -4;
    public static final byte KEY_EXTENSION = -3;
    public static final byte TIME_SYNC = -2;
    public static final byte KEY_RESET = -1;
    private byte flag;

    public NetFlag(byte flag) {
        this.flag = flag;
    }

    public NetFlag() {
    }

    public NetFlag set(byte mask) {
        this.flag = (byte)(this.flag | mask);
        return this;
    }

    public static byte getSecureMask(byte code) {
        if (code < 0) {
            return 0;
        }
        return (byte)(code & 1 | code & 2);
    }

    public boolean isA(byte m) {
        return (this.flag & m) != 0;
    }

    public byte getFlag() {
        return this.flag;
    }

    public static boolean isSecure(byte code) {
        if (code < 0) {
            return false;
        }
        return (code & 1 | code & 2) != 0;
    }

    public static boolean isRouterHandle(byte code) {
        if (code <= 0) {
            return false;
        }
        return (code & 8) != 0;
    }
}

