/*
 * Decompiled with CFR 0.152.
 */
package whatap.logsink.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import whatap.agent.Logger;
import whatap.agent.conf.ConfLogSink;
import whatap.agent.data.DataPackSender;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.LogSinkPack;
import whatap.lang.pack.LogSinkZipPack;
import whatap.lang.value.MapValue;
import whatap.util.AnsiPrint;
import whatap.util.DateUtil;
import whatap.util.RequestQueue;
import whatap.util.ThreadUtil;

public class ZipSendProxyThread
extends Thread {
    private static ZipSendProxyThread instance;
    RequestQueue<LogSinkPack> queue = new RequestQueue(ConfLogSink.logsink_pack_queue_size);
    public long queueDropped = 0L;
    static long lastDropped;
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    int packCount = 0;
    long first_time;

    public static final synchronized ZipSendProxyThread getInstance() {
        if (instance == null) {
            instance = new ZipSendProxyThread();
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void add(LogSinkPack p) {
        boolean ok = this.queue.put(p);
        if (!ok) {
            if (ConfLogSink.debug_logsink_dropped_enabled) {
                Logger.println("ZipSendProxy", 10, "LogSinkPack dropped: " + this.queueDropped + ", queue size: " + this.queue.size() + ", capacity: " + this.queue.getCapacity());
            }
            if (ConfLogSink.debug_logsink_dropped_detail_enabled) {
                StringBuffer sb = new StringBuffer();
                sb.append("[");
                sb.append(AnsiPrint.green(p.category));
                sb.append("|" + AnsiPrint.yellow(p.line));
                sb.append("] ");
                if (p.content != null) {
                    if (ConfLogSink.debug_logsink_limit_content_length > 2 && p.content.length() > ConfLogSink.debug_logsink_limit_content_length) {
                        sb.append(p.content.substring(0, ConfLogSink.debug_logsink_limit_content_length - 2));
                    } else {
                        sb.append(p.content);
                    }
                }
                if (p.content != null && !p.content.endsWith("\n")) {
                    sb.append("\n");
                }
                Logger.write(sb.toString());
            }
            ++this.queueDropped;
        }
    }

    public void logSelf(CounterPack1 cp) {
        if (lastDropped == this.queueDropped) {
            return;
        }
        lastDropped = this.queueDropped;
        if (cp.extra == null) {
            cp.extra = new MapValue();
        }
        if (cp.extra != null) {
            cp.extra.put("logsink_pack_drop", this.queueDropped);
        }
    }

    public void addWait(LogSinkPack p, long waitTimeForFull) {
        boolean ok = this.queue.put(p);
        if (!ok && waitTimeForFull > 0L) {
            while (!this.queue.put(p)) {
                ThreadUtil.sleep(waitTimeForFull);
            }
        }
    }

    public void run() {
        while (true) {
            LogSinkPack log = this.queue.get(ConfLogSink.logsink_max_wait_time);
            try {
                if (log != null) {
                    this.append(log);
                    continue;
                }
                this.sendAndClear();
            }
            catch (Throwable throwable) {
            }
        }
    }

    private void append(AbstractPack p) throws IOException {
        this.buffer.write(DataOutputX.toBytes(p));
        ++this.packCount;
        if (this.first_time == 0L) {
            this.first_time = p.time;
            if (this.buffer.size() >= ConfLogSink.logsink_max_buffer_size) {
                this.sendAndClear();
            }
        } else if (this.buffer.size() >= ConfLogSink.logsink_max_buffer_size || p.time - this.first_time >= (long)ConfLogSink.logsink_max_wait_time) {
            this.sendAndClear();
        }
    }

    private void sendAndClear() {
        if (this.buffer.size() == 0) {
            return;
        }
        LogSinkZipPack p = new LogSinkZipPack();
        p.time = DateUtil.currentTime();
        p.reset(this.packCount, this.buffer.toByteArray(), ConfLogSink.logsink_zip_min_size);
        if (ConfLogSink.debug_logsink_zip_enabled) {
            Logger.println("logsink " + AnsiPrint.green("zip status=" + p.status + " records=" + p.recordCount + " | " + this.buffer.size() + "=>" + p.records.length));
        }
        DataPackSender.sendLogSink(p);
        this.buffer.reset();
        this.first_time = 0L;
        this.packCount = 0;
    }

    public void flush() {
        while (this.queue.size() > 0) {
            ThreadUtil.sleep(10L);
        }
        this.sendAndClear();
    }

    static {
        lastDropped = 0L;
    }
}

