/*
 * Decompiled with CFR 0.152.
 */
package whatap.logsink.watch;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfLogSink;
import whatap.lang.conf.ConfObserver;
import whatap.logsink.watch.WatchLog;
import whatap.util.SortUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringLinkedSet;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class WatchLogManager
extends Thread {
    private static WatchLogManager instance;
    protected Configure conf = Configure.getInstance();
    public boolean watchEnabled = false;
    private StringKeyLinkedMap<WatchLog> table = new StringKeyLinkedMap<WatchLog>(){

        @Override
        protected WatchLog create(String key) {
            return new WatchLog(key);
        }
    };

    public static final synchronized WatchLogManager getInstance() {
        if (instance == null) {
            instance = new WatchLogManager();
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void run() {
        this.resetDogList(true);
        this.watchEnabled = ConfLogSink.watchlog_enabled;
        ConfObserver.add("watchLog", new Runnable(){

            public void run() {
                WatchLogManager.this.resetDogList(ConfLogSink.watchlog_enabled != WatchLogManager.this.watchEnabled);
                WatchLogManager.this.watchEnabled = ConfLogSink.watchlog_enabled;
            }
        });
        while (true) {
            if (!this.watchEnabled) {
                ThreadUtil.sleep(5000L);
                continue;
            }
            ThreadUtil.sleep(ConfLogSink.watchlog_check_interval);
            this.process();
        }
    }

    private void process() {
        Enumeration<WatchLog> en = this.table.values();
        while (en.hasMoreElements()) {
            WatchLog dog = en.nextElement();
            try {
                if (!dog.isActive()) continue;
                dog.process();
            }
            catch (Throwable e) {
                dog.stop();
                Logger.println("WLOG", 10, e);
            }
        }
    }

    private void resetDogList(boolean reset) {
        String id;
        StringLinkedSet ids = new StringLinkedSet();
        Properties prop = this.conf.property;
        Enumeration<?> en = prop.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith("watchlog.") || !key.endsWith(".enabled")) continue;
            String id2 = key.substring("watchlog.".length(), key.length() - ".enabled".length());
            ids.put(id2);
        }
        String[] idlist = SortUtil.sort(ids.elements(), ids.size());
        for (int i = 0; i < idlist.length; ++i) {
            id = idlist[i];
            boolean enabled = this.conf.getBoolean("watchlog." + id + ".enabled", false);
            String file = this.conf.getValue("watchlog." + id + ".file");
            String[] words = this.conf.getStringSet("watchlog." + id + ".words", "", ",").getArray();
            int check_interval = this.conf.getInt("watchlog." + id + ".check_interval", 1000);
            if (StringUtil.isNotEmpty(file) && words.length > 0) {
                WatchLog dog = this.table.intern(id);
                dog.config(id, new File(file));
                dog.words = words;
                dog.check_interval = Math.max(check_interval, 1000);
                if (reset) {
                    dog.reset();
                }
                if (enabled) {
                    dog.activate();
                    continue;
                }
                dog.stop();
                continue;
            }
            ids.remove(id);
        }
        StringEnumer en1 = this.table.keys();
        while (en1.hasMoreElements()) {
            id = en1.nextString();
            if (ids.contains(id)) continue;
            this.table.remove(id);
        }
    }
}

