/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.slog;

import java.util.ArrayList;
import java.util.List;
import whatap.lang.slog.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLogParser {
    private static final String INDICATOR = "+";
    private String[] head;
    private char startCh = (char)91;
    private char endCh = (char)93;

    public SLogParser(String ... head) {
        this('[', ']', head);
    }

    public SLogParser(char startCh, char endCh, String ... head) {
        this.head = head;
        this.startCh = startCh;
        this.endCh = endCh;
    }

    public List<Field> parse(String log) {
        ArrayList<Field> out = new ArrayList<Field>();
        char[] str = log.toCharArray();
        int headLen = this.head.length;
        ArrayList<String> headValue = new ArrayList<String>();
        StringBuilder word = new StringBuilder();
        boolean beginValue = false;
        for (int i = 0; i < str.length; ++i) {
            char ch = str[i];
            if (!beginValue) {
                if (ch != this.startCh) continue;
                beginValue = true;
                continue;
            }
            if (ch == this.endCh) {
                beginValue = false;
                String value = word.toString().trim();
                if (value.equals(INDICATOR)) {
                    this.setHead(out, headValue);
                    this.parse(out, str, i);
                    return out;
                }
                if (headValue.size() < headLen) {
                    headValue.add(value);
                }
                word = new StringBuilder();
                continue;
            }
            word.append(ch);
        }
        this.setHead(out, headValue);
        return out;
    }

    private void setHead(List<Field> out, List<String> headValue) {
        for (int i = 0; i < headValue.size(); ++i) {
            out.add(new Field(this.head[i], headValue.get(i)));
        }
    }

    private void parse(List<Field> out, char[] str, int p) {
        boolean startQuart = false;
        boolean startValue = false;
        String key = null;
        String value = null;
        StringBuilder buf = new StringBuilder();
        block5: for (int i = p; i < str.length; ++i) {
            switch (str[i]) {
                case ' ': {
                    if (startQuart) {
                        buf.append(' ');
                        continue block5;
                    }
                    if (buf.length() > 0) {
                        value = buf.toString();
                        buf = new StringBuilder();
                    }
                    if (key != null && value != null) {
                        out.add(new Field(key, value));
                    }
                    key = null;
                    value = null;
                    startQuart = false;
                    startValue = false;
                    continue block5;
                }
                case '=': {
                    if (startValue || startQuart) {
                        buf.append('=');
                        continue block5;
                    }
                    if (buf.length() <= 0) continue block5;
                    key = buf.toString();
                    buf = new StringBuilder();
                    startValue = true;
                    continue block5;
                }
                case '\"': {
                    if (startQuart) {
                        if (buf.length() > 0) {
                            value = buf.toString();
                            buf = new StringBuilder();
                        }
                        if (key != null && value != null) {
                            out.add(new Field(key, value));
                        }
                        key = null;
                        value = null;
                        startQuart = false;
                        continue block5;
                    }
                    startQuart = true;
                    continue block5;
                }
                default: {
                    buf.append(str[i]);
                }
            }
        }
        if (buf.length() > 0) {
            value = buf.toString();
            buf = new StringBuilder();
        }
        if (key != null && value != null) {
            out.add(new Field(key, value));
        }
    }
}

