/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.Enumeration;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.value.BooleanValue;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;
import whatap.net.ParamDef;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;

public class ParamPack
extends AbstractPack {
    public int id;
    protected StringKeyLinkedMap<Value> table = new StringKeyLinkedMap();
    public long request;
    public long response;

    public int size() {
        return this.table.size();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.table.containsKey(key);
    }

    public StringEnumer keys() {
        return this.table.keys();
    }

    public String[] keyArray() {
        return this.table.keyArray();
    }

    public Value get(String key) {
        return this.table.get(key);
    }

    public boolean getBoolean(String key) {
        Value v = this.get(key);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return false;
    }

    public int getInt(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }

    public long getLong(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).longValue();
        }
        return 0L;
    }

    public float getFloat(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return 0.0f;
    }

    public String getText(String key) {
        Value v = this.get(key);
        if (v instanceof TextValue) {
            return ((TextValue)v).value;
        }
        return null;
    }

    public Value put(String key, Value value) {
        return this.table.put(key, value);
    }

    public Value put(String key, String value) {
        return this.put(key, new TextValue(value));
    }

    public Value put(String key, long value) {
        return this.put(key, new DecimalValue(value));
    }

    public Value remove(String key) {
        return this.table.remove(key);
    }

    public void clear() {
        this.table.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ParamPack ");
        buf.append(super.toString());
        buf.append(" id=").append(this.id + " (" + ParamDef.values.get(this.id)).append(") ");
        buf.append(" request=").append(this.request + " ");
        buf.append(" response=").append(this.response + " ");
        buf.append(this.table);
        return buf.toString();
    }

    public short getPackType() {
        return 256;
    }

    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeInt(this.id);
        dout.writeDecimal(this.request);
        dout.writeDecimal(this.response);
        dout.writeDecimal(this.table.size());
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = this.table.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> e = en.nextElement();
            dout.writeText(e.getKey());
            dout.writeValue(e.getValue());
        }
    }

    public Pack read(DataInputX din) {
        super.read(din);
        this.id = din.readInt();
        this.request = din.readDecimal();
        this.response = din.readDecimal();
        int count = (int)din.readDecimal();
        for (int t = 0; t < count; ++t) {
            String key = din.readText();
            Value value = din.readValue();
            this.put(key, value);
        }
        return this;
    }

    public ListValue newList(String name) {
        ListValue list = new ListValue();
        this.put(name, list);
        return list;
    }

    public ListValue getList(String key) {
        return (ListValue)this.table.get(key);
    }

    public ListValue getListNotNull(String key) {
        ListValue lv = (ListValue)this.table.get(key);
        return lv == null ? new ListValue() : lv;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public MapValue toMapValue() {
        MapValue map = new MapValue();
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = this.table.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> e = en.nextElement();
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    public ParamPack setMapValue(MapValue mapValue) {
        if (mapValue == null) {
            return this;
        }
        StringEnumer keys = mapValue.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextString();
            Value value = mapValue.get(key);
            this.table.put(key, value);
        }
        return this;
    }

    public ParamPack reponse() {
        if (this.request == 0L) {
            return this;
        }
        this.response = this.request;
        this.request = 0L;
        return this;
    }

    public String toFormatString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toFormatString());
        buf.append(", id=").append(this.id + " (" + ParamDef.values.get(this.id)).append(") ");
        buf.append(", request=").append(this.request);
        buf.append(", response=").append(this.response).append("\n");
        StringEnumer en = this.table.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            buf.append("\t").append(key).append("=").append(this.table.get(key)).append("\n");
        }
        return buf.toString();
    }
}

