/*
 * Decompiled with CFR 0.152.
 */
package whatap.io;

import java.util.Enumeration;
import whatap.io.IFlushable;
import whatap.util.DateUtil;
import whatap.util.IntKeyMap;
import whatap.util.ThreadUtil;

public class FlushCtr
extends Thread {
    private static FlushCtr instance = null;
    private IntKeyMap<FlushItem> table = new IntKeyMap();
    private boolean running = true;

    public static final synchronized FlushCtr getInstance() {
        if (instance == null) {
            instance = new FlushCtr();
            instance.setDaemon(true);
            instance.setName("FlushCtr");
            instance.start();
        }
        return instance;
    }

    protected FlushCtr() {
    }

    public void shutdown() {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            try {
                this.process();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ThreadUtil.sleep(1000L);
        }
    }

    public void regist(IFlushable object) {
        this.table.put(System.identityHashCode(object), new FlushItem(object));
    }

    public void unregist(IFlushable object) {
        this.table.remove(System.identityHashCode(object));
        if (object.isDirty()) {
            object.flush();
        }
    }

    private void process() {
        Enumeration<FlushItem> en = this.table.values();
        while (en.hasMoreElements()) {
            FlushItem f = en.nextElement();
            long now = DateUtil.currentTime();
            if (!f.object.isDirty() || now < f.lastFlushTime + f.object.interval()) continue;
            f.lastFlushTime = now;
            f.object.flush();
        }
    }

    private static class FlushItem {
        long lastFlushTime = DateUtil.currentTime();
        IFlushable object;

        public FlushItem(IFlushable object) {
            this.object = object;
        }
    }
}

