/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import whatap.agent.Logger;

public class HttpClientUtil {
    public static String read(String url, int timeout) {
        try {
            return HttpClientUtil.read(new URL(url), timeout);
        }
        catch (Throwable t) {
            Logger.println(t.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(URL u, int timeout) {
        HttpURLConnection uc = null;
        try {
            uc = (HttpURLConnection)u.openConnection();
            if (timeout > 0) {
                uc.setConnectTimeout(timeout);
            }
            uc.connect();
            InputStream in = uc.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int length = 0;
            while ((length = in.read(buf)) >= 0) {
                out.write(buf, 0, length);
            }
            String string = new String(out.toByteArray());
            return string;
        }
        catch (SocketTimeoutException e) {
            Logger.println(e + " timeout=" + timeout + " " + u);
        }
        catch (Exception e) {
            Logger.println(e.toString());
        }
        finally {
            if (uc != null) {
                uc.disconnect();
            }
        }
        return null;
    }
}

