/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.util;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.TreeSet;
import whatap.agent.boot.AgentBoot;
import whatap.util.FileUtil;
import whatap.util.JarUtil;

public class HomeUtil {
    private static String home = JarUtil.getJarLocation(AgentBoot.class);
    private static String currentName = JarUtil.getJarFileName(AgentBoot.class);

    public static String[] getTraceJarFiles() {
        File[] files;
        TreeSet<String> out = new TreeSet<String>();
        File homeDir = new File(home);
        for (File file : files = homeDir.listFiles()) {
            if (!file.getName().startsWith("whatap.agent-") || !file.getName().endsWith(".jar")) continue;
            out.add(file.getName());
        }
        return out.toArray(new String[out.size()]);
    }

    public static boolean delete(String tracer) {
        if (HomeUtil.isCurrentTracer(tracer)) {
            throw new RuntimeException("can not delete the activated tracer");
        }
        if (!HomeUtil.isTracer(tracer)) {
            return false;
        }
        return new File(home, tracer).delete();
    }

    private static boolean isCurrentTracer(String tracer) {
        return currentName == null || currentName.indexOf(tracer) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void save(String file, long pos, byte[] data) {
        if (!HomeUtil.isTracer(file)) {
            return;
        }
        File f = new File(home, file + ".tmp");
        if (pos == 0L) {
            if (f.exists()) {
                f.delete();
            }
        } else if (f.length() < pos) {
            return;
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "rw");
            raf.seek(pos);
            raf.write(data);
        }
        catch (Exception exception) {
            FileUtil.close(raf);
            catch (Throwable throwable) {
                FileUtil.close(raf);
                throw throwable;
            }
        }
        FileUtil.close(raf);
    }

    public static void done(String file, long size, int crc32) {
        if (HomeUtil.isCurrentTracer(file)) {
            return;
        }
        File f = new File(home, file + ".tmp");
        if (f.length() != size) {
            return;
        }
        int fcrc = FileUtil.getCrc(f);
        if (fcrc == 0 || fcrc != crc32) {
            return;
        }
        f.renameTo(new File(home, file));
    }

    private static boolean isTracer(String file) {
        return file.startsWith("whatap.agent-") && file.endsWith(".jar");
    }
}

