/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.httpc;

import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.plugin.PluginHttpCallEnd;
import whatap.agent.plugin.PluginHttpCallStart;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.httpc.HttpcTraceHelper;
import whatap.agent.trace.httpc.urlnorm.HttpcUrlNorm;
import whatap.lang.step.HttpcStepX;
import whatap.util.IntLinkedSet;

public class ForHttpURLConnection
implements HttpcTraceHelper.IHelper {
    Configure conf = Configure.getInstance();
    static ThreadLocal<Long> stepIdTable = new ThreadLocal();
    static IntLinkedSet urlConTable = new IntLinkedSet().setMax(10000);
    private static int logCount = 5;

    public boolean start(TraceContext ctx, HttpcStepX step, HookArgs hookPoint) {
        try {
            int urlConHash = System.identityHashCode(hookPoint.this1);
            if (urlConTable.contains(urlConHash)) {
                return false;
            }
            step.driver = "HttpURLConnection";
            HttpURLConnection urlCon = (HttpURLConnection)hookPoint.this1;
            if ("connect".equals(hookPoint.method) || "getOutputStream".equals(hookPoint.method)) {
                this.transfer(ctx, step, urlCon);
                stepIdTable.set(step.stepId);
                return false;
            }
            urlConTable.put(urlConHash);
            boolean ok = false;
            if (stepIdTable.get() == null) {
                ok = true;
            } else {
                Long id = stepIdTable.get();
                if (id != null) {
                    step.stepId = id;
                    stepIdTable.set(null);
                }
            }
            URL url = urlCon.getURL();
            ctx.httpc_url = url.getPath();
            ctx.httpc_url = ConfTrace.trace_origin_httpc_enabled ? HttpcUrlNorm.normalize(ctx.httpc_url, step) : HttpcUrlNorm.normalize(ctx.httpc_url);
            if ("".equals(ctx.httpc_url)) {
                ctx.httpc_url = "/";
            }
            ctx.httpc_host = url.getHost();
            ctx.httpc_port = url.getPort();
            if (ctx.httpc_port <= 0) {
                ctx.httpc_port = "https".equals(url.getProtocol()) ? 443 : 80;
            }
            if (ok) {
                this.transfer(ctx, step, urlCon);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (ctx.httpc_url == null) {
            ctx.httpc_url = hookPoint.class1;
        }
        return true;
    }

    private void transfer(TraceContext ctx, HttpcStepX step, HttpURLConnection urlCon) {
        try {
            if (ConfMTrace.mtrace_enabled) {
                String traceparent;
                urlCon.setRequestProperty(ConfMTrace._trace_mtrace_poid_key, TraceContext.transferPOID());
                if (ConfMTrace.stat_mtrace_enabled) {
                    urlCon.setRequestProperty(ConfMTrace._trace_mtrace_spec_key1, ctx.transferSPEC_URL1());
                }
                if (ConfMTrace.mtid_mtrace_enabled && ctx.mtid != 0L) {
                    urlCon.setRequestProperty(ConfMTrace._trace_mtrace_caller_key, ctx.transferMTID_CALLERTX(step.stepId));
                }
                if (ConfMTrace.mtrace_traceparent_enabled && (traceparent = ctx.trasferMTID_TRACEPARENT(step.stepId)) != null) {
                    urlCon.setRequestProperty(ConfMTrace._trace_mtrace_traceparent_key, traceparent);
                }
            }
            PluginHttpCallStart.process(ctx, urlCon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void checkTarget(HookArgs hookPoint) {
    }

    public HttpcTraceHelper.HttpcEndValue end(TraceContext ctx, HookArgs hookPoint, Throwable thr) {
        try {
            HttpcTraceHelper.HttpcEndValue httpcEndValue = new HttpcTraceHelper.HttpcEndValue();
            HttpURLConnection urlCon = (HttpURLConnection)hookPoint.this1;
            httpcEndValue.exception = thr;
            try {
                httpcEndValue.status = urlCon.getResponseCode();
                if (httpcEndValue.status >= 400) {
                    httpcEndValue.status_reason = urlCon.getResponseMessage();
                }
            }
            catch (SocketTimeoutException e) {
                httpcEndValue.status = 0;
                httpcEndValue.status_reason = e.toString();
                Logger.println("ForHttpURLConnection", 10, e.toString());
            }
            PluginHttpCallEnd.process(ctx, httpcEndValue);
            return httpcEndValue;
        }
        catch (Throwable t) {
            if (logCount-- > 0) {
                Logger.println("ForHttpURLConnection", t);
            }
            return null;
        }
    }
}

