/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfHook;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.meter.MeterHTTPC;
import whatap.agent.data.DataTextAgent;
import whatap.agent.stat.ErrorArg;
import whatap.agent.stat.StatError;
import whatap.agent.stat.StatHttpc;
import whatap.agent.trace.BuildPos;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.HttpcContext;
import whatap.agent.trace.LocalContext;
import whatap.agent.trace.LogSinkRemoteAccessStatus;
import whatap.agent.trace.SocketInputStreamWrap;
import whatap.agent.trace.SocketTable;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.exception.ExceptionAlert;
import whatap.agent.trace.httpc.HttpcTraceHelper;
import whatap.lang.http.HttpStatus;
import whatap.lang.step.HttpcStepX;
import whatap.lang.step.MessageStep;
import whatap.lang.step.SocketStep;
import whatap.notice.WHATAP_ERROR;
import whatap.util.HashUtil;
import whatap.util.IntSet;
import whatap.util.KeyGen;
import whatap.util.StringUtil;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class TraceHttpc {
    private static Configure conf = Configure.getInstance();
    public static int mtrace_tot;
    public static int mtrace_ok;
    public static int mtrace_tot_old;
    public static int mtrace_ok_old;
    static int stacklog_count;
    private static long last_log;
    private static int FILE_READ_OPEN;
    private static int FILE_WRITE_OPEN;

    public static Object startHttpc(String className, String methodName, String methodDesc, Object _this, Object[] arg) {
        try {
            if (!TraceHttpc.conf.httpc_enabled) {
                return null;
            }
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                if (TraceHttpc.conf.httpc_unknown_stacklog_enabled) {
                    TraceHttpc.stackLog("httpc-" + className + "." + methodName);
                }
                return null;
            }
            if (ctx.active_httpc_hash != 0) {
                return null;
            }
            TraceHttpc.setRatedMtraceKey(ctx);
            HttpcStepX step = new HttpcStepX();
            step.stepId = TraceContext.getNextCallerStepId();
            step.start_time = ctx.getElapsedTime();
            HookArgs hookPoint = new HookArgs(className, methodName, methodDesc, _this, arg);
            HttpcTraceHelper.IHelper helper = HttpcTraceHelper.start(ctx, step, hookPoint);
            if (helper == null) {
                return null;
            }
            if (ctx.httpc_url != null) {
                step.url = HashUtil.hash(ctx.httpc_url);
                DataTextAgent.HTTPC_URL.add(step.url, ctx.httpc_url);
            }
            if (TraceHttpc.conf.httpc_hostport_enabled && ctx.httpc_port > 0) {
                ctx.httpc_host = ctx.httpc_host + ":" + ctx.httpc_port;
                ctx.httpc_port = 0;
            } else {
                step.port = ctx.httpc_port;
            }
            if (ctx.httpc_host != null) {
                step.host = ctx.httpc_host_hash = HashUtil.hash(ctx.httpc_host);
                DataTextAgent.HTTPC_HOST.add(step.host, ctx.httpc_host);
            }
            if (ConfTrace.trace_httpc_resource_enabled) {
                if (TraceHttpc.conf.trace_cpu_step_enabled) {
                    step.start_cpu = (int)(SysJMX.getCurrentThreadCPU() - ctx.start_cpu);
                }
                if (TraceHttpc.conf.trace_malloc_step_enabled) {
                    step.start_mem = (int)(SysJMX.getCurrentThreadAllocBytes() - ctx.start_malloc);
                }
            }
            if (ConfTrace._trace_position_httpc_hash != 0) {
                BuildPos.profileHttpcPos(step, ctx.httpc_url);
            }
            ctx.profile.push(step);
            ctx.active_httpc_hash = step.url;
            ctx.httpc_stime = step.start_time;
            return new HttpcContext(ctx, step, hookPoint, helper);
        }
        catch (Throwable t) {
            Logger.println("A126", 10, t);
            return null;
        }
    }

    public static boolean isMtraceSampleOk() {
        return false;
    }

    public static void resetMtraceRate() {
        mtrace_tot_old = mtrace_tot;
        mtrace_tot = 0;
        mtrace_ok_old = mtrace_ok;
        mtrace_ok = 0;
    }

    public static void setRatedMtraceKey(TraceContext ctx) {
        if (!ctx.mtid_build_checked) {
            long next;
            if (ctx.mtid == 0L && Math.abs((next = KeyGen.next()) / 100L % 100L) < (long)ConfMTrace.mtrace_rate) {
                ctx.mtid = next;
            }
            ctx.mtid_build_checked = true;
        }
    }

    public static void endHttpc(Object stat, Object returnValue, Throwable thr) {
        if (stat == null) {
            return;
        }
        try {
            HttpcContext httpc_ctx = (HttpcContext)stat;
            TraceContext ctx = httpc_ctx.context;
            HttpcStepX step = (HttpcStepX)httpc_ctx.step;
            if (ctx.httpc_update_name != null && ctx.httpc_update_name.length() > 0) {
                step.url = HashUtil.hash(ctx.httpc_update_name);
                DataTextAgent.HTTPC_URL.add(step.url, ctx.httpc_update_name);
            }
            if (httpc_ctx.helper != null) {
                httpc_ctx.hookArgs.returnValue = returnValue;
                HttpcTraceHelper.HttpcEndValue hs = httpc_ctx.helper.end(ctx, httpc_ctx.hookArgs, thr);
                if (hs != null) {
                    step.status = hs.status;
                    if (TraceHttpc.conf.httpc_status_error_enable) {
                        TraceHttpc.checkStatusAndError(ctx, step, hs.status_reason, thr);
                    }
                }
            }
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            if (step.error == 0L && step.elapsed > ConfTrace.trace_error_httpc_time_max) {
                TraceHttpc.handleHttpcSlowError(ctx, step);
            }
            if (step.error == 0L) {
                LogSinkRemoteAccessStatus.httpOk(ctx.httpc_host, step);
            }
            MeterHTTPC.getInstance().add(step.host, step.elapsed, step.error != 0L);
            StatHttpc.getInstance().addHttpcTime(ctx.service_hash, step.url, step.host, step.port, step.elapsed, step.error != 0L);
            ctx.active_httpc_hash = 0;
            ctx.httpc_url = null;
            ctx.httpc_host = null;
            ctx.httpc_host_hash = 0;
            ctx.httpc_stime = 0;
            ++ctx.httpc_count;
            ctx.httpc_time += step.elapsed;
            ctx.profile.pop(step);
        }
        catch (Throwable t) {
            Logger.println("A127", 10, t);
        }
    }

    public static void checkStatusAndError(TraceContext ctx, HttpcStepX step, String status_reason, Throwable t) {
        switch (step.status / 100) {
            case 4: 
            case 5: {
                if (TraceHttpc.conf.httpc_status_ignore.contains(step.status)) {
                    return;
                }
                if (TraceHttpc.ignoreStatusByUrl(step.status, step.url)) {
                    return;
                }
                if (TraceHttpc.ignoreStatusByHost(step.status, step.host)) {
                    return;
                }
                if (t != null) {
                    TraceHttpc.handleHttpcExceptionError(ctx, step, t);
                    return;
                }
                ErrorArg arg = TraceHttpc.attachHttpcStatusErrorArg(ctx, step, status_reason);
                if (TraceHttpc.conf.httpc_status_error_mode == 2) {
                    if (TraceHttpc.conf.httpc_status_alert_ignore.contains(step.status)) {
                        arg.level = (byte)10;
                    } else if (TraceHttpc.ignoreHttpcStatusAlert(step.status, step.url)) {
                        arg.level = (byte)10;
                    }
                }
                ExceptionAlert.getInstance().httpc(ctx, arg, step.status, status_reason);
                LogSinkRemoteAccessStatus.httpError(ctx.httpc_host, ctx.httpc_url, step);
                return;
            }
        }
    }

    public static void handleHttpcExceptionError(TraceContext ctx, HttpcStepX step, Throwable thr) {
        ErrorArg arg = TraceHttpc.attachHttpcExceptionErrorArg(ctx, step, thr);
        ctx.handleHttpcErrorStack(thr);
        LogSinkRemoteAccessStatus.httpError(ctx.httpc_host, ctx.httpc_url, step, thr);
        ExceptionAlert.getInstance().httpc(ctx, arg);
    }

    public static void handleHttpcSlowError(TraceContext ctx, HttpcStepX step) {
        ErrorArg arg = TraceHttpc.attachHttpcSlowErrorArg(ctx, step);
        ExceptionAlert.getInstance().httpc(ctx, arg);
    }

    private static ErrorArg attachHttpcStatusErrorArg(TraceContext ctx, HttpcStepX step, String statusReason) {
        if (statusReason == null || statusReason.length() == 0) {
            statusReason = HttpStatus.reason(step.status, "");
        }
        String errorMessage = new StringBuffer().append(statusReason).append("(status ").append(step.status).append(")").toString();
        return TraceHttpc.attachErrorArg(ctx, step, WHATAP_ERROR.httpc_error, errorMessage);
    }

    private static ErrorArg attachHttpcExceptionErrorArg(TraceContext ctx, HttpcStepX step, Throwable thr) {
        return TraceHttpc.attachErrorArg(ctx, step, thr, thr.getMessage());
    }

    private static ErrorArg attachHttpcSlowErrorArg(TraceContext ctx, HttpcStepX step) {
        return TraceHttpc.attachErrorArg(ctx, step, WHATAP_ERROR.slow_httpc, WHATAP_ERROR.slow_httpc.getMessage());
    }

    private static ErrorArg attachErrorArg(TraceContext ctx, HttpcStepX step, Throwable thr, String errorMessage) {
        ErrorArg arg = new ErrorArg();
        arg.exception = thr;
        arg.message = errorMessage;
        arg.status = step.status;
        arg.setTraceCtx(ctx);
        arg.appendHttpc(step.url);
        step.error = StatError.getInstance().addError(arg);
        return arg;
    }

    static boolean ignoreHttpcStatusAlert(int status, int url) {
        if (!TraceHttpc.conf._has_httpc_status_url_alert_ignore_set) {
            return false;
        }
        IntSet set = TraceHttpc.conf.httpc_status_url_alert_ignore_set.get(status);
        if (set == null) {
            return false;
        }
        return set.contains(url);
    }

    static boolean ignoreStatusByUrl(int status, int url) {
        if (!TraceHttpc.conf._has_httpc_status_url_ignore_set) {
            return false;
        }
        IntSet set = TraceHttpc.conf.httpc_status_url_ignore_set.get(status);
        if (set == null) {
            return false;
        }
        return set.contains(url);
    }

    static boolean ignoreStatusByHost(int status, int host) {
        if (!TraceHttpc.conf._has_httpc_status_host_ignore_set) {
            return false;
        }
        IntSet set = TraceHttpc.conf.httpc_status_host_ignore_set.get(status);
        if (set == null) {
            return false;
        }
        return set.contains(host);
    }

    private static void stackLog(String title) {
        if (stacklog_count <= 0) {
            return;
        }
        --stacklog_count;
        long now = System.currentTimeMillis();
        if (now - last_log >= 5000L) {
            last_log = now;
            Logger.yellow(title + "\n" + ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 3));
        }
    }

    public static Object startSocket(Socket socket, SocketAddress addr, int timeout) {
        if (!(addr instanceof InetSocketAddress)) {
            return null;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            if (TraceHttpc.conf.trace_background_socket_enabled) {
                InetSocketAddress inet = (InetSocketAddress)addr;
                InetAddress host = inet.getAddress();
                int port = inet.getPort();
                byte[] ipaddr = host == null ? null : host.getAddress();
                SocketTable.add(ipaddr, port, 0, 0L);
            }
            return null;
        }
        try {
            ctx.socket_connecting = true;
            SocketStep step = new SocketStep();
            step.start_time = ctx.getElapsedTime();
            InetSocketAddress inet = (InetSocketAddress)addr;
            InetAddress host = inet.getAddress();
            int port = inet.getPort();
            step.ipaddr = host == null ? null : host.getAddress();
            step.port = port;
            ctx.profile.push(step);
            return new LocalContext(ctx, step, socket);
        }
        catch (Throwable t) {
            Logger.println("A128", 10, "socket trace error", t);
            return null;
        }
    }

    public static void endSocket(Object stat, Throwable thr) {
        if (stat == null) {
            return;
        }
        try {
            LocalContext lctx = (LocalContext)stat;
            TraceContext ctx = lctx.context;
            SocketStep step = (SocketStep)lctx.step;
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            if (thr != null) {
                ErrorArg arg = new ErrorArg();
                arg.exception = thr;
                arg.message = thr.getMessage();
                arg.setTraceCtx(ctx);
                step.error = StatError.getInstance().addError(arg);
                LogSinkRemoteAccessStatus.socketError("error", step.ipaddr, step.port, thr.getMessage());
                ctx.handleSocketErrorStack(thr);
            }
            ctx.socket_connecting = false;
            ctx.profile.pop(step);
            SocketTable.add(step.ipaddr, step.port, ctx.service_hash, ctx.txid);
        }
        catch (Throwable t) {
            Logger.println("A129", 10, "socket trace close error", t);
        }
    }

    public static void openWriteFile(Object file) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null || ctx.disable_file_trace) {
            return;
        }
        if (FILE_WRITE_OPEN == 0) {
            FILE_WRITE_OPEN = HashUtil.hash("FileWriteOpen");
            DataTextAgent.MESSAGE.add(FILE_WRITE_OPEN, "FileWriteOpen");
        }
        try {
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = FILE_WRITE_OPEN;
            step.desc = file == null ? "null" : file.toString();
            ctx.profile.add(step);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void openReadFile(Object file) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null || ctx.disable_file_trace) {
            return;
        }
        try {
            if (FILE_READ_OPEN == 0) {
                FILE_READ_OPEN = HashUtil.hash("FileReadOpen");
                DataTextAgent.MESSAGE.add(FILE_READ_OPEN, "FileReadOpen");
            }
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = FILE_READ_OPEN;
            if (file == null) {
                step.desc = "noname";
                ctx.profile.add(step);
            } else {
                if (ConfTrace.trace_filebody_enabled) {
                    step.desc = TraceHttpc.profileFileContent(ctx, file.toString());
                } else {
                    long length;
                    step.desc = file.toString();
                    if (ConfTrace.trace_file_length_enabled && (length = TraceHttpc.profileFileLength(file.toString())) > 0L) {
                        String format = String.format("%.2f MB", (double)length / 1048576.0);
                        step.desc = step.desc + " (" + format + ")";
                    }
                }
                ctx.profile.add(step);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String profileFileContent(TraceContext ctx, String file) {
        block22: {
            ctx.disable_file_trace = true;
            try {
                String string;
                FileInputStream in;
                block21: {
                    if (!file.endsWith(ConfTrace.trace_filebody_postfix)) {
                        String string2 = file;
                        return string2;
                    }
                    File f = new File(file);
                    if (!f.exists() || f.length() == 0L) {
                        String string3 = file;
                        return string3;
                    }
                    int len = Math.min((int)f.length(), ConfTrace.trace_filebody_length);
                    byte[] buff = new byte[len];
                    in = null;
                    in = new FileInputStream(f);
                    in.read(buff);
                    string = file + "\n" + new String(buff);
                    if (in == null) break block21;
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return string;
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block22;
                        catch (Throwable throwable2) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
            finally {
                ctx.disable_file_trace = false;
            }
        }
        return file;
    }

    private static long profileFileLength(String file) {
        try {
            File f = new File(file);
            if (!f.exists() || f.length() == 0L) {
                return 0L;
            }
            long len = f.length();
            return len;
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static InputStream getSocketInputStream(InputStream in, Socket sock) {
        if (TraceHttpc.conf.trace_socket_timeout_enabled) {
            return new SocketInputStreamWrap(in, sock);
        }
        return in;
    }

    public static void startName(String className, String method, String firstString) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            switch (ConfHook.hook_httpc_name_mode) {
                case 0: {
                    ctx.httpc_update_name = className;
                    break;
                }
                case 1: {
                    ctx.httpc_update_name = method;
                    break;
                }
                case 2: {
                    ctx.httpc_update_name = StringUtil.truncate(firstString, 128);
                }
            }
        }
    }

    public static void endName(Object returnValue) {
        TraceContext ctx;
        if (returnValue != null && ConfHook.hook_httpc_name_mode >= 10 && (ctx = TraceContextManager.getLocalContext()) != null) {
            ctx.httpc_update_name = StringUtil.truncate(returnValue.toString(), 128);
        }
    }

    public static void main(String[] args) {
        String fileName = "/Users/user/Documents/my/whatap/dev/Git/agentjava/io.whatap.java/packageDeploy/package/agent/java/whatap.agent-2.2.52.SNAPSHOT.jar";
        File file = new File(fileName);
        long fileSizeInMB = file.length() / 0x100000L;
        System.out.println("fileSizeInMB=" + fileSizeInMB);
        double fileSizeInMB2 = (double)file.length() / 1048576.0;
        System.out.println("fileSizeInMB2=" + fileSizeInMB2);
        BigDecimal fileSize = new BigDecimal(file.length());
        BigDecimal megabyte = new BigDecimal(0x100000);
        BigDecimal fileSizeInMB3 = fileSize.divide(megabyte, 2, RoundingMode.HALF_UP);
        System.out.println("fileSizeInMB3=" + fileSizeInMB3);
        String fileSizeInMB4 = String.format("%.2f MB", (double)file.length() / 1048576.0);
        System.out.println("fileSizeInMB4=" + fileSizeInMB4);
        StringBuilder desc = new StringBuilder();
        desc.append(fileName);
        long length = TraceHttpc.profileFileLength(fileName);
        String format = String.format("%.2f MB", (double)length / 1048576.0);
        desc.append(" (").append(format).append(")");
        System.out.println("desc=" + desc);
    }

    static {
        stacklog_count = 100;
        last_log = 0L;
    }
}

