/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.tags;

import whatap.agent.Logger;
import whatap.agent.conf.ConfAgentTags;
import whatap.agent.data.DataPackSender;
import whatap.agent.tags.AwsTagHelper;
import whatap.agent.util.AsyncRunner;
import whatap.lang.pack.ParamPack;
import whatap.lang.value.MapValue;
import whatap.util.DateUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.ThreadUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentMetaTags {
    public static StringKeyLinkedMap<String> cloudMetaAndTag;
    private static long lastConfTagHash;
    private static long lastSent;

    protected static MapValue getMapValue() {
        MapValue m = new MapValue();
        AgentMetaTags.put(m, cloudMetaAndTag);
        AgentMetaTags.put(m, ConfAgentTags.agent_meta_tags);
        return m;
    }

    protected static void put(MapValue m, StringKeyLinkedMap<String> o) {
        if (o == null) {
            return;
        }
        StringEnumer en = o.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            String value = o.get(key);
            if (value == null) continue;
            m.put(key, value);
        }
    }

    public static void sendTags() {
        boolean confTagHash;
        long now = System.currentTimeMillis();
        boolean bl = confTagHash = lastConfTagHash == (long)ConfAgentTags.agent_meta_tags_hash;
        if (confTagHash && now < lastSent + 300000L) {
            return;
        }
        lastSent = now;
        lastConfTagHash = ConfAgentTags.agent_meta_tags_hash;
        AsyncRunner.getInstance().add(new Runnable(){

            public void run() {
                try {
                    AwsTagHelper.loadCloudTags();
                }
                catch (Throwable t) {
                    Logger.println(ThreadUtil.getStackTrace(t));
                }
                try {
                    if (ConfAgentTags.agent_meta_tags_enabled) {
                        AgentMetaTags.sendData();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    protected static void sendData() {
        ParamPack p = new ParamPack();
        p.time = DateUtil.now();
        p.id = 450;
        p.put("tags", AgentMetaTags.getMapValue());
        DataPackSender.send(p);
    }

    static {
        lastConfTagHash = 0L;
        lastSent = 0L;
    }
}

