/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import whatap.agent.Logger;
import whatap.agent.conf.ConfStat;
import whatap.agent.net.TcpSession;
import whatap.agent.stat.StatError;
import whatap.agent.stat.StatHttpc;
import whatap.agent.stat.StatRemoteIPURL;
import whatap.agent.stat.StatRemoteIp;
import whatap.agent.stat.StatSql;
import whatap.agent.stat.StatTranx;
import whatap.agent.stat.StatTranxDomain;
import whatap.agent.stat.StatTranxLogin;
import whatap.agent.stat.StatTranxMtCaller;
import whatap.agent.stat.StatTranxReferer;
import whatap.agent.stat.StatTranxStatus;
import whatap.agent.stat.StatUserAgent;
import whatap.agent.util.ThreadNameUtil;
import whatap.lang.slog.SLog;
import whatap.util.DateUtil;
import whatap.util.ThreadUtil;

public class TimingSender
extends Thread {
    private static TimingSender instance;

    public static synchronized TimingSender startInstance() {
        if (instance == null) {
            instance = new TimingSender();
            instance.setDaemon(true);
            instance.start();
            ThreadNameUtil.whatap(instance);
        }
        return instance;
    }

    public void run() {
        long lastUnit = ConfStat.stat_1m_enabled ? DateUtil.getMinUnit(DateUtil.currentTime()) : DateUtil.getFiveMinUnit(DateUtil.currentTime());
        while (true) {
            ThreadUtil.sleep(1000L);
            long nowUnit = ConfStat.stat_1m_enabled ? DateUtil.getMinUnit(DateUtil.currentTime()) : DateUtil.getFiveMinUnit(DateUtil.currentTime());
            if (lastUnit >= nowUnit) continue;
            lastUnit = nowUnit;
            try {
                long now = DateUtil.now() / 60000L * 60000L;
                if (ConfStat.stat_enabled) {
                    if (ConfStat.debug_stat_enabled) {
                        this.log();
                    }
                    StatTranx.getInstance().send(now);
                    StatTranxDomain.getInstance().send(now);
                    StatTranxMtCaller.getInstance().send(now);
                    StatTranxLogin.getInstance().send(now);
                    StatTranxReferer.getInstance().send(now);
                    StatSql.getInstance().send(now);
                    StatHttpc.getInstance().send(now);
                    StatError.getInstance().send(now);
                    StatRemoteIp.getInstance().send(now);
                    StatRemoteIPURL.getInstance().send(now);
                    StatTranxStatus.getInstance().send(now);
                    StatUserAgent.getInstance().send(now);
                } else {
                    StatTranx.getInstance().clear();
                    StatTranxDomain.getInstance().clear();
                    StatTranxMtCaller.getInstance().clear();
                    StatSql.getInstance().clear();
                    StatHttpc.getInstance().clear();
                    StatError.getInstance().clear();
                    StatRemoteIp.getInstance().clear();
                    StatRemoteIPURL.getInstance().clear();
                    StatUserAgent.getInstance().clear();
                    StatTranxLogin.getInstance().clear();
                    StatTranxReferer.getInstance().clear();
                    StatTranxStatus.getInstance().clear();
                }
                ThreadUtil.sleep(30000L);
                continue;
            }
            catch (Throwable e) {
                Logger.println("stat-error", 0, e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    protected void log() {
        SLog sb = new SLog();
        sb.append("id", "Send-stat-packs");
        sb.a("tcp", TcpSession.getInstance().isOpen() ? "isOpen" : "isClosed");
        sb.a("tx", StatTranx.getInstance().size());
        sb.a("error", StatError.getInstance().size());
        sb.a("sql", StatSql.getInstance().size());
        sb.a("httpc", StatHttpc.getInstance().size());
        sb.a("caller", StatTranxMtCaller.getInstance().size());
        sb.a("domain", StatTranxDomain.getInstance().size());
        sb.a("login", StatTranxLogin.getInstance().size());
        sb.a("referer", StatTranxReferer.getInstance().size());
        sb.a("remoteIp", StatRemoteIp.getInstance().size());
        sb.a("status", StatTranxStatus.getInstance().size());
        sb.a("userAgent", StatUserAgent.getInstance().size());
        Logger.println(sb.green());
    }
}

