/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import whatap.agent.conf.ConfTrace;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.TraceContext;
import whatap.notice.WHATAP_ERROR;
import whatap.util.HashUtil;
import whatap.util.StringUtil;

public class ErrorArg {
    public Throwable exception;
    public String className;
    public int classNameHash;
    public String message;
    public int messageHash;
    public int serviceHash;
    public byte appendType;
    public int appendHash;
    public long txErrorCode;
    public int status;
    public byte level = (byte)20;
    public int sqlErrorCode;

    public void appendSql(int hash) {
        this.appendType = (byte)2;
        this.appendHash = hash;
    }

    public void appendHttpc(int hash) {
        this.appendType = (byte)4;
        this.appendHash = hash;
    }

    public void setTraceCtx(TraceContext ctx) {
        if (ctx != null) {
            this.serviceHash = ctx.service_hash;
            if (ctx.error == null) {
                ctx.error = this;
                ctx.profile(this);
            }
        }
    }

    boolean build() {
        if (this.message != null) {
            this.message = StringUtil.trimEmpty(this.message);
            this.message = StringUtil.truncate(this.message, 200);
            this.messageHash = HashUtil.hash(this.message);
            DataTextAgent.ERROR.add(this.messageHash, this.message);
        }
        this.className = this.sqlErrorCode > 0 && ConfTrace.trace_sql_errorcode_enabled ? new StringBuilder(31).append(this.exception.getClass().getName()).append("(").append(this.sqlErrorCode).append(")").toString() : this.exception.getClass().getName();
        boolean isWhatap = this.className.startsWith("whatap.");
        if (isWhatap) {
            this.className = this.className.substring(this.className.lastIndexOf(".") + 1);
            if (this.exception == WHATAP_ERROR.httpc_error) {
                this.className = this.className + "(" + this.status + ")";
            }
            if (this.exception == WHATAP_ERROR.status_error) {
                this.className = this.className + "(" + this.status + ")";
            }
        }
        this.classNameHash = HashUtil.hash(this.className);
        DataTextAgent.ERROR.add(this.classNameHash, this.className);
        return isWhatap;
    }

    void buildSimple() {
        if (this.message != null) {
            this.message = StringUtil.trimEmpty(this.message);
            this.message = StringUtil.truncate(this.message, 200);
            this.messageHash = HashUtil.hash(this.message);
            DataTextAgent.ERROR.add(this.messageHash, this.message);
        }
        if (this.className != null) {
            this.classNameHash = HashUtil.hash(this.className);
            DataTextAgent.ERROR.add(this.classNameHash, this.className);
        }
    }
}

