/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.io.File;
import java.util.Arrays;
import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.data.DataPackSender;
import whatap.agent.logo.Logo;
import whatap.agent.net.TcpRequestMgr;
import whatap.agent.net.TcpSession;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.TagCountPack;
import whatap.util.DateUtil;
import whatap.util.FileUtil;
import whatap.util.JarUtil;
import whatap.util.KeyGen;
import whatap.util.StringUtil;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class NetPing2 {
    public static void main(String[] args) {
        System.setProperty("whatap.disabled", "true");
        if (System.getProperty("whatap.home") == null) {
            String home = JarUtil.getJarLocation(NetPing2.class);
            System.setProperty("whatap.home", home);
        }
        Configure conf = Configure.getInstance();
        Configure.getInstance().waitForInit();
        Configure.TCP_SESSION_ALLOWED = true;
        SecurityMaster.getInstance();
        Object[] fields = NetPing2.fields("/Users/paul/tmp/f.txt");
        System.out.println(Arrays.toString(fields));
        System.setProperty("whatap.name", "BULK-PING-{pid}");
        Logo.print();
        long seed = DateUtil.currentTime() ^ (long)SysJMX.getProcessPID() << 32;
        KeyGen.setSeed(seed);
        TcpRequestMgr.getInstance();
        TcpSession.getInstance().waitForConnection();
        int sleepMs = 5000;
        long lastSysTime = System.currentTimeMillis();
        while (true) {
            NetPing2.sleepx(sleepMs / 1000);
            long time = DateUtil.currentTime() / (long)sleepMs * (long)sleepMs;
            CounterPack1 pw = new CounterPack1();
            pw.time = time;
            pw.duration = (int)((DateUtil.systime() - lastSysTime + 499L) / 1000L);
            lastSysTime = DateUtil.systime();
            pw.active_tx_slice = new short[]{10, 10, 10};
            pw.tps = 10.0f;
            pw.resp_time = 100;
            pw.cpu = 50.0f * ConfSysMon.correction_factor_cpu;
            System.out.println(DateUtil.timestamp() + " SEND PING DATA");
            NetPing2.sendTag(time, (String[])fields);
            try {
                TcpRequestMgr.getInstance().logSelf(pw);
                DataPackSender.send(pw);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static String[] fields(String file) {
        byte[] b = FileUtil.readAll(new File(file));
        if (b == null) {
            return new String[]{"noFieldName"};
        }
        String[] s = StringUtil.tokenizer(new String(b), "\n");
        return s;
    }

    private static void sendTag(long time, String[] fields) {
        TagCountPack p = new TagCountPack();
        p.category = "net_ping";
        p.time = time;
        p.tags.put("type", "java");
        for (int i = 0; i < 4000; ++i) {
            p.put(fields[i % fields.length] + i, i);
        }
        DataPackSender.send(p);
    }

    private static void sleepx(int sec) {
        ThreadUtil.sleep(1000L);
        long now;
        while ((now = DateUtil.currentTime() / 1000L) != now / (long)sec * (long)sec) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
            }
        }
        return;
    }
}

