/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import whatap.agent.AgentTransformer;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.setup.ClassCV;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.AnsiPrint;

class ClassPrintCV
extends ClassVisitor
implements Opcodes {
    private boolean isInterface;

    public static String c(String name) {
        return name.replace('/', '.');
    }

    public ClassPrintCV() {
        super(IASM.API, AgentTransformer.getClassWriter(ClassCV.classDesc));
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        name = ClassPrintCV.c(name);
        superName = ClassPrintCV.c(superName);
        superName = superName.equals("java.lang.Object") ? "" : " extends " + AnsiPrint.cyan(superName);
        System.out.println(AsmUtil.getClassAccessString(access) + AnsiPrint.green(name) + superName + " " + (interfaces.length > 0 ? "implements " + AnsiPrint.cyan(AsmUtil.infToString(interfaces)) : "") + "{");
        this.isInterface = AsmUtil.isInterface(access);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        System.out.println("\t " + AsmUtil.getMethodAccessString(access, this.isInterface) + AsmUtil.getReturnString(desc) + " " + AnsiPrint.cyan(name) + AsmUtil.getArgString(desc));
        return mv;
    }

    public void visitEnd() {
        System.out.println("}");
    }
}

