/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.net;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.CypherConf;
import whatap.agent.control.ControlHandler;
import whatap.agent.net.TcpReturn;
import whatap.agent.net.TcpSession;
import whatap.io.DataInputX;
import whatap.net.NetFlag;
import whatap.util.ArrayUtil;
import whatap.util.DateUtil;
import whatap.util.ThreadUtil;

public class Receiver
extends Thread {
    TcpSession w = TcpSession.getInstance();
    Configure conf = Configure.getInstance();

    public Receiver() {
        this.setDaemon(true);
    }

    public void run() {
        SecurityMaster.getInstance();
        while (true) {
            if (!this.w.isOpen()) {
                ThreadUtil.sleep(50L);
                continue;
            }
            try {
                TcpReturn out = this.w.read();
                if (out.code == -2) {
                    DataInputX in = new DataInputX(out.data);
                    long prevAgentTime = in.readLong();
                    long serverTime = in.readLong();
                    long now = System.currentTimeMillis();
                    long turnaroundTime = now - prevAgentTime;
                    if (turnaroundTime >= 500L) continue;
                    DateUtil.setServerTime(serverTime, 1.0);
                    continue;
                }
                if (this.conf.cypher_level > 0) {
                    if (out.transfer_key != CypherConf.TRANSFER_KEY) continue;
                    switch (NetFlag.getSecureMask(out.code)) {
                        case 1: {
                            if (CypherConf.cypher == null) break;
                            out.data = CypherConf.cypher.hide(out.data);
                            break;
                        }
                        case 2: {
                            if (CypherConf.cypher == null) break;
                            out.data = CypherConf.cypher.decrypt(out.data, 0, out.data.length);
                            break;
                        }
                        default: {
                            out.data = null;
                        }
                    }
                }
                if (ArrayUtil.isEmpty(out.data)) continue;
                ControlHandler.getInstance().add(new DataInputX(out.data).readPack());
                continue;
            }
            catch (Throwable t) {
                Logger.println("A116", 10, t.toString());
                continue;
            }
            break;
        }
    }
}

