/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.kube;

import java.util.ArrayList;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.kube.SessionMap;
import whatap.agent.net.TcpReqClientProxy;
import whatap.agent.tools.KubeUtil;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.H1;
import whatap.lang.conf.ConfigMake;
import whatap.lang.value.MapValue;
import whatap.util.IPUtil;
import whatap.util.StopWatch;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KubeClient
extends Thread {
    private static KubeClient instance = null;
    public String node_agent_host = null;
    public int node_agent_port = 6600;
    private SessionMap netMaster = new SessionMap();
    private SessionMap netNode = new SessionMap();
    public long node_recv_time;
    public float cpu;
    public float cpu_sys;
    public float cpu_user;
    public float throttled_periods;
    public float throttled_time;
    public float metering;
    public long memory;
    public long failcnt;
    public long limit;
    public long maxUsage;

    public static final synchronized KubeClient getInstance() {
        if (instance == null) {
            instance = new KubeClient();
            instance.setDaemon(true);
            instance.setName("KubeClient");
            instance.start();
        }
        return instance;
    }

    @Override
    public void run() {
        Configure conf = Configure.getInstance();
        while (true) {
            ThreadUtil.sleep(3000L);
            try {
                if (conf.WHATAP_MICRO_ENABLED && conf.kube_agent_connect_enabled) {
                    this.process(Configure.POD_NAME);
                    continue;
                }
                ThreadUtil.sleep(11000L);
            }
            catch (Throwable throwable) {
            }
        }
    }

    public void process(String podname) {
        SecurityMaster secu = SecurityMaster.getInstance();
        MapValue p = new MapValue();
        p.put("cmd", "regist");
        p.put("pcode", secu.PCODE);
        p.put("oid", secu.OID);
        p.put("oname", secu.ONAME);
        p.put("ip", IPUtil.toString(secu.IP));
        p.put("hostname", SysJMX.getHostName());
        p.put("kube.micro", true);
        if (podname != null) {
            p.put("pod_name", podname);
        }
        Configure conf = Configure.getInstance();
        if (conf.OKIND != 0) {
            p.put("okind", conf.OKIND);
            p.put("okind_name", conf.OKIND_NAME);
        }
        if (conf.ONODE != 0) {
            p.put("onode", conf.ONODE);
            p.put("onode_name", conf.ONODE_NAME);
        }
        if (KubeUtil.container_id != null) {
            p.put("container_id", KubeUtil.container_id);
        }
        if (Configure.POD_NAME != null) {
            p.put("pod_name", Configure.POD_NAME);
        }
        this.sendTo("Master", this.netMaster, conf.master_agent_host, conf.master_agent_port, p, new H1<MapValue>(){

            @Override
            public void process(MapValue m) throws Exception {
                String host = m.getText("node.agent.ip");
                int port = m.getInt("node.agent.port");
                if (host != null) {
                    KubeClient.this.node_agent_host = host;
                }
                if (port != 0) {
                    KubeClient.this.node_agent_port = port;
                }
                String confbaseid = m.getText("confbase.id");
                String confbasehost = m.getText("confbase.ip");
                int confbaseport = m.getInt("confbase.port");
                if (confbasehost != null && confbaseport != 0) {
                    ArrayList<String> removes = new ArrayList<String>();
                    ArrayList<String> keys = new ArrayList<String>();
                    ArrayList<String> values = new ArrayList<String>();
                    keys.add("confbase_id");
                    values.add(confbaseid);
                    keys.add("confbase_enabled");
                    values.add("true");
                    keys.add("confbase_host");
                    values.add(confbasehost);
                    keys.add("confbase_port");
                    values.add(Integer.toString(confbaseport));
                    ConfigMake.reset(Configure.getInstance().getPropertyFile(), keys, values, removes);
                }
            }
        });
        this.sendTo("WorkNode", this.netNode, this.node_agent_host, this.node_agent_port, p, new H1<MapValue>(){

            @Override
            public void process(MapValue m) throws Exception {
                KubeClient.this.cpu = m.getFloat("cpu");
                KubeClient.this.cpu_sys = m.getFloat("cpu_sys");
                KubeClient.this.cpu_user = m.getFloat("cpu_user");
                KubeClient.this.throttled_periods = m.getFloat("throttled_periods");
                KubeClient.this.throttled_time = m.getFloat("throttled_time");
                KubeClient.this.memory = m.getLong("memory");
                KubeClient.this.failcnt = m.getLong("failcnt");
                KubeClient.this.limit = m.getLong("limit");
                KubeClient.this.maxUsage = m.getLong("maxUsage");
                KubeClient.this.node_recv_time = System.currentTimeMillis();
                KubeClient.this.metering = m.getFloat("metering");
            }
        });
    }

    private void sendTo(String prefix, SessionMap smap, String host, int port, MapValue p, H1<MapValue> h) {
        if (host == null) {
            smap.close();
            Logger.println(prefix, 30, prefix + " no host address");
            return;
        }
        StopWatch st = new StopWatch();
        try {
            TcpReqClientProxy client = smap.open(prefix, host, port);
            if (client == null) {
                return;
            }
            client.send(DataOutputX.toBytes(p));
            byte[] out = client.read();
            if (out != null) {
                h.process((MapValue)new DataInputX(out).readValue());
            }
        }
        catch (Throwable t) {
            Logger.println(prefix, 60, t + " " + st.getTime() + " ms");
        }
    }
}

