/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.dyna;

import java.lang.instrument.ClassDefinition;
import java.util.ArrayList;
import java.util.List;
import whatap.agent.AgentTransformer;
import whatap.agent.Configure;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.util.ClassUtil;
import whatap.util.ThreadUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicBootHook {
    Configure conf = Configure.getInstance();

    public void run() {
        try {
            ReservedSet classSet = new ReservedSet();
            List<IASM> asms = AgentTransformer.getInstance().asms;
            for (int i = 0; i < asms.size(); ++i) {
                asms.get(i).reserved(classSet);
            }
            this.redefine(classSet);
            ThreadUtil.sleep(5L);
        }
        catch (Throwable t) {
            Logger.println("A102", 10, "boot hook fail: " + t);
        }
    }

    private void redefine(List<ClassDefinition> classSubSet) throws Exception {
        if (classSubSet.size() > 0) {
            ClassDefinition[] cd = classSubSet.toArray(new ClassDefinition[classSubSet.size()]);
            JavaAgent.instrumentation.redefineClasses(cd);
        }
    }

    private void redefine(ReservedSet classSet) {
        ArrayList<ClassDefinition> classDefList = new ArrayList<ClassDefinition>();
        Class[] c = JavaAgent.instrumentation.getAllLoadedClasses();
        Class lastClass = null;
        for (int i = 0; i < c.length; ++i) {
            byte[] body;
            if (!classSet.include(c[i]) || (body = ClassUtil.getByteCode(c[i])) == null) continue;
            lastClass = c[i];
            classDefList.add(new ClassDefinition(c[i], body));
            if (classDefList.size() < this.conf.boot_redefine_size) continue;
            try {
                this.redefine(classDefList);
                Logger.println("A104", 10, "Redefine Class : " + lastClass + "+" + classDefList.size());
            }
            catch (Exception e) {
                Logger.println("A105", 10, "Fail to redefine : " + lastClass + "+" + classDefList.size());
            }
            classDefList.clear();
        }
        if (classDefList.size() > 0) {
            try {
                this.redefine(classDefList);
                Logger.println("A106", 10, "Redefine Class : " + lastClass + "+" + classDefList.size());
            }
            catch (Exception e) {
                Logger.println("A107", 10, "Fail to redefine : " + lastClass + "+" + classDefList.size());
            }
        }
    }
}

