/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.JavaXDBConPoolFold;
import whatap.agent.counter.task.pools.BasicDataSourcePool;
import whatap.agent.counter.task.pools.C3P0DataSourcePool;
import whatap.agent.counter.task.pools.DruidConnPool;
import whatap.agent.counter.task.pools.HbyrisDataSourcePool;
import whatap.agent.counter.task.pools.HikariConnPool;
import whatap.agent.counter.task.pools.IConnPoolObject;
import whatap.agent.counter.task.pools.JBossConnPool;
import whatap.agent.counter.task.pools.JBossDataSourcePool;
import whatap.agent.counter.task.pools.JeusConnPool;
import whatap.agent.counter.task.pools.MyDataSource;
import whatap.agent.counter.task.pools.TomcatConnnPool;
import whatap.agent.counter.task.pools.UserDefinedDbPool;
import whatap.agent.counter.task.pools.WebLogicConnPool;
import whatap.agent.counter.task.pools.other.JmxPool;
import whatap.agent.counter.task.pools.other.TomcatDataSource;
import whatap.agent.counter.task.pools.other.WebLogicDS10;
import whatap.agent.trace.ConPool;
import whatap.util.IntIntMap;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.ThreadUtil;

public class DBConCountCollectorThread
extends Thread {
    private static DBConCountCollectorThread instance = null;
    public IntIntMap db_num_active = new IntIntMap(7, 1.0f);
    public IntIntMap db_num_idle = new IntIntMap(7, 1.0f);
    public StringKeyLinkedMap<IConnPoolObject> parser = new StringKeyLinkedMap();
    Configure conf = Configure.getInstance();

    public static final synchronized DBConCountCollectorThread getInstance() {
        if (instance == null) {
            instance = new DBConCountCollectorThread();
            instance.setName("WhaTap-DBConCountCollector");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public DBConCountCollectorThread() {
        this.add(new BasicDataSourcePool());
        this.add(new C3P0DataSourcePool());
        this.add(new HikariConnPool());
        this.add(new HbyrisDataSourcePool());
        this.add(new JBossConnPool());
        this.add(new JBossDataSourcePool());
        this.add(new JeusConnPool());
        this.add(new TomcatConnnPool());
        this.add(new WebLogicConnPool());
        this.add(new DruidConnPool());
        this.add(new MyDataSource());
    }

    private void add(IConnPoolObject p) {
        this.parser.put(p.id(), p);
    }

    public void run() {
        while (true) {
            long tm = ConfPool.counter_pool_interval;
            ThreadUtil.sleep(Math.max(tm, 5000L));
            try {
                this.process();
                continue;
            }
            catch (Throwable t) {
                Logger.println("Whatap-DBC", 10, t);
                continue;
            }
            break;
        }
    }

    private void process() {
        if (!ConfPool.counter_pool_enabled) {
            this.db_num_active = null;
            this.db_num_idle = null;
            return;
        }
        IntIntMap num_act = new IntIntMap(11, 1.0f);
        IntIntMap num_idle = new IntIntMap(11, 1.0f);
        if (ConfPool.jmx_pool_enabled) {
            JmxPool.process(num_act, num_idle);
        }
        if (ConfPool.tomcat_ds_enabled) {
            TomcatDataSource.process(num_act, num_idle);
        }
        if (ConfPool.weblogic_ds_enabled) {
            WebLogicDS10.process(num_act, num_idle);
        }
        StringEnumer en = ConPool.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            IConnPoolObject cp = this.parser.get(key);
            if (cp != null) {
                cp.process(num_act, num_idle);
                continue;
            }
            UserDefinedDbPool.process(key, num_act, num_idle);
        }
        if (this.conf.tagcount_subset_v2_enabled) {
            JavaXDBConPoolFold.sendAndReset();
        }
        this.db_num_active = num_act;
        this.db_num_idle = num_idle;
    }
}

