/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.DBPoolClassUtil;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.counter.task.pools.IConnPoolObject;
import whatap.agent.counter.task.pools.PoolObjectReflect;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.ConPool;
import whatap.lang.var.IntString;
import whatap.util.HashUtil;
import whatap.util.IntIntMap;
import whatap.util.IntKeyLinkedMap;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

public class BasicDataSourcePool
implements IConnPoolObject {
    public static String className = "BasicDataSourcePool";
    static int classNameHash = HashUtil.hash(className);
    private static IntKeyLinkedMap<IntString> poolUrlMap = new IntKeyLinkedMap().setMax(100);

    public String id() {
        return className;
    }

    public boolean process(IntIntMap db_num_active, IntIntMap db_num_idle) {
        if (!ConfPool.dbcp_pool_enabled) {
            return false;
        }
        StringKeyLinkedMap<CNT> detail = new StringKeyLinkedMap<CNT>(){

            @Override
            protected CNT create(String key) {
                return new CNT();
            }
        };
        try {
            Enumeration<WeakReference<Object>> poolEnum = ConPool.getObjectEnum(className);
            while (poolEnum.hasMoreElements()) {
                int idle;
                int act;
                Object pool = poolEnum.nextElement().get();
                if (pool == null) continue;
                int poolHash = System.identityHashCode(pool);
                IntString jdbcUrl = poolUrlMap.get(poolHash);
                if (jdbcUrl == null) {
                    jdbcUrl = new IntString();
                    jdbcUrl.v2 = PoolObjectReflect.getStringNoException(pool, "getUrl");
                    if (jdbcUrl.v2 != null) {
                        jdbcUrl.v2 = StringUtil.cutOut(jdbcUrl.v2, "?");
                        jdbcUrl.v1 = HashUtil.hash(jdbcUrl.v2);
                        DataTextAgent.dbc(jdbcUrl.v1, jdbcUrl.v2);
                    } else {
                        DataTextAgent.dbc(classNameHash, className);
                        jdbcUrl.v1 = classNameHash;
                        jdbcUrl.v2 = className;
                    }
                    poolUrlMap.put(poolHash, jdbcUrl);
                }
                if ((act = PoolObjectReflect.getInt(pool, "getNumActive")) > 0) {
                    db_num_active.add(jdbcUrl.v1, act);
                }
                if ((idle = PoolObjectReflect.getInt(pool, "getNumIdle")) > 0) {
                    db_num_idle.add(jdbcUrl.v1, idle);
                }
                if (!ConfPool.pool_detail_enabled) continue;
                ((CNT)detail.intern(jdbcUrl.v2)).add(act, idle);
                if (!ConfPool.debug_pool_detail_enabled) continue;
                Logger.println("DBPOOL", className + ": pool=" + jdbcUrl.v2 + " act=" + act + " idle=" + idle);
            }
            if (ConfPool.pool_detail_enabled) {
                DBPoolClassUtil.poolDetail(className, detail);
            }
            return true;
        }
        catch (Throwable e) {
            Logger.println("BasicDataSourcePool", 3600000, e + ",hotfix: dbcp_pool_enabled=false");
            return false;
        }
    }
}

