/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import java.util.ArrayList;
import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.api.trace.TxTrace;
import whatap.agent.app.AppCtxStatCollector;
import whatap.agent.app.vertx.VertxReceiveRequestStatCollector;
import whatap.agent.app.vertx.VertxSendRequestStatCollector;
import whatap.agent.app.vertx.VertxStatRedisClientCollector;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.meter.ActiveStackDump;
import whatap.agent.counter.meter.AsyncStackDump;
import whatap.agent.counter.meter.LongtimeActiveWarning;
import whatap.agent.counter.meter.MeterActiveX;
import whatap.agent.counter.meter.MeterUsers;
import whatap.agent.counter.meter.ThreadDump;
import whatap.agent.open.OpenMxEng;
import whatap.agent.trace.Alert;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.lang.pack.CounterPack1;
import whatap.lang.step.SqlStepX;
import whatap.notice.WHATAP_ERROR;

public class ServiceActiveTransaction
implements ICounterTask {
    Configure conf = Configure.getInstance();

    public ServiceActiveTransaction() {
        ActiveStackDump.getInstance();
        AsyncStackDump.getInstance();
        if (this.conf.thread_dump_enabled) {
            ThreadDump.getInstance();
        }
    }

    public void process(CounterPack1 pack) {
        ArrayList<TraceContext> terminate;
        if (pack.active_tx_slice == null) {
            pack.active_tx_slice = new short[3];
        }
        Enumeration<TraceContext> en = TraceContextManager.getContextEnumeration();
        ArrayList<TraceContext> arrayList = terminate = this.conf.tx_active_timeout <= 0L ? null : new ArrayList<TraceContext>();
        if (this.conf.thread_dump_enabled && this.conf.thread_dump_actx > 0 && TraceContextManager.size() >= this.conf.thread_dump_actx) {
            ThreadDump.trigger();
        }
        MeterActiveX activeX = null;
        if (this.conf.actx_meter_enabled) {
            activeX = MeterActiveX.getInstance();
            activeX.reinit();
        }
        if (pack.active_stat == null) {
            pack.active_stat = new short[5];
        }
        AppCtxStatCollector perfByContext = AppCtxStatCollector.getInstance();
        VertxReceiveRequestStatCollector perfByVertxReceiveRequest = VertxReceiveRequestStatCollector.getInstance();
        VertxSendRequestStatCollector perfByVertxSendRequest = VertxSendRequestStatCollector.getInstance();
        VertxStatRedisClientCollector perfByVertxStatRedisClient = VertxStatRedisClientCollector.getInstance();
        while (en.hasMoreElements()) {
            int elapsed;
            TraceContext ctx;
            block27: {
                ctx = en.nextElement();
                if (ctx == null || !ctx.addActiveTxCounterEnabled) continue;
                if (ctx.closed) {
                    TraceContextManager.endAsync(ctx.txid);
                    continue;
                }
                int div = 0;
                elapsed = ctx.getElapsedTime();
                if (elapsed < ctx.trace_active_transaction_yellow_time) {
                    pack.active_tx_slice[0] = (short)(pack.active_tx_slice[0] + 1);
                } else if (elapsed < ctx.trace_active_transaction_red_time) {
                    pack.active_tx_slice[1] = (short)(pack.active_tx_slice[1] + 1);
                    div = 1;
                } else {
                    pack.active_tx_slice[2] = (short)(pack.active_tx_slice[2] + 1);
                    div = 2;
                }
                ++pack.active_tx_count;
                perfByContext.activeTx(ctx.appctx, div);
                if (activeX != null) {
                    activeX.addTx(ctx.mcaller_pcode, ctx.mcaller_okind, ctx.mcaller_oid, div);
                    int httpc_host_hash = ctx.httpc_host_hash;
                    if (httpc_host_hash != 0) {
                        activeX.addHttpc(httpc_host_hash, elapsed - ctx.httpc_stime);
                    } else {
                        SqlStepX sql = ctx.sql;
                        if (sql != null) {
                            activeX.addSql(sql.dbc, elapsed - sql.start_time);
                        }
                    }
                }
                this.countingStatus(ctx, pack);
                if (this.conf.auto_thread_kill_enabled && this.conf.auto_thread_kill_elapsed >= 1000 && this.conf.auto_thread_kill_elapsed < elapsed) {
                    try {
                        if (this.conf.auto_thread_kill_domain.size() != 0 && !this.conf.auto_thread_kill_domain.contains(ctx.http_host_hash) || ctx.thread_auto_killed) break block27;
                        ctx.thread_auto_killed = true;
                        try {
                            ctx.thread.stop();
                        }
                        catch (Exception httpc_host_hash) {
                            // empty catch block
                        }
                        long thrid = ctx.thread == null ? 0L : ctx.thread.getId();
                        String tname = ctx.thread == null ? "unknown" : ctx.thread.getName();
                        String msg = "Auto thread killed url=" + ctx.service_name + " thread=[" + thrid + "] " + tname + " elapsed=" + elapsed;
                        if (this.conf.auto_thread_kill_warning_enabled) {
                            Alert.autoThreadKill(ctx.service_name, thrid, tname, elapsed, msg);
                        }
                        Logger.info("THREAD-KILL", msg);
                    }
                    catch (Throwable t) {
                        Logger.println("THREAD-KILL", 10, "auto thread killed url=" + ctx.service_name, t);
                    }
                }
            }
            if (terminate != null && (long)elapsed >= this.conf.tx_active_timeout) {
                terminate.add(ctx);
            }
            MeterUsers.addActive(ctx.wclientId);
        }
        if (terminate != null) {
            for (int i = 0; i < terminate.size(); ++i) {
                TraceContext ctx = (TraceContext)terminate.get(i);
                TxTrace.endTx(ctx, WHATAP_ERROR.lost_trace);
            }
        }
        if (this.conf.long_active_alert_limit > 0L) {
            LongtimeActiveWarning.getInstance();
        }
        if (this.conf.too_many_actx_alert_enabled) {
            Alert.checkTooManyActiveTx(pack.active_tx_count);
        }
        if (this.conf.app_context_enabled) {
            perfByContext.trigger(pack.time);
        }
        if (this.conf.vertx_context_enabled) {
            perfByVertxReceiveRequest.trigger(pack.time);
            perfByVertxSendRequest.trigger(pack.time);
            perfByVertxStatRedisClient.trigger(pack.time);
        }
        OpenMxEng.app_tx_active_count = pack.active_tx_count;
    }

    private void countingStatus(TraceContext ctx, CounterPack1 pack) {
        if (ctx.sql != null) {
            pack.active_stat[1] = (short)(pack.active_stat[1] + 1);
        } else if (ctx.active_httpc_hash != 0) {
            pack.active_stat[2] = (short)(pack.active_stat[2] + 1);
        } else if (ctx.db_opening) {
            pack.active_stat[3] = (short)(pack.active_stat[3] + 1);
        } else if (ctx.socket_connecting) {
            pack.active_stat[4] = (short)(pack.active_stat[4] + 1);
        } else {
            pack.active_stat[0] = (short)(pack.active_stat[0] + 1);
        }
    }
}

