/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter.tx;

import whatap.agent.Configure;
import whatap.agent.counter.meter.tx.BucketHitMap;
import whatap.agent.counter.meter.tx.BucketHitView;
import whatap.lang.service.TxRecord;

public class MeterServiceBackground {
    private static MeterServiceBackground inst;
    Configure conf = Configure.getInstance();
    private BucketHitMap hitmap;

    public static synchronized MeterServiceBackground getInstance() {
        if (inst == null) {
            inst = new MeterServiceBackground();
        }
        return inst;
    }

    public MeterServiceBackground() {
        this.hitmap = this.conf.hitview_enabled ? new BucketHitView() : new BucketHitMap();
    }

    public void addVirtualTx(TxRecord tx) {
        this.addTxErr(tx, tx.errorLevel >= 20);
    }

    private void addTxErr(TxRecord tx, boolean err) {
        this.hitmap.add(tx, err);
    }

    public void add(TxRecord tx) {
        boolean err;
        boolean bl = err = tx.errorLevel >= 20;
        if (this.conf.hitmap_status_mode_enabled) {
            boolean hErr = this.checkHitMapErr(tx);
            this.addTxErr(tx, hErr);
        } else {
            this.addTxErr(tx, err);
        }
    }

    private boolean checkHitMapErr(TxRecord tx) {
        if (this.conf._has_hitmap_status_mode_error_set && this.conf.hitmap_status_mode_error_set.contains(tx.status)) {
            tx.errorLevel = (byte)20;
            return true;
        }
        if (this.conf._has_hitmap_status_mode_ignore_set && this.conf.hitmap_status_mode_ignore_set.contains(tx.status)) {
            tx.errorLevel = 0;
            return false;
        }
        int status = tx.status / 100;
        if (status == 5) {
            tx.errorLevel = (byte)20;
            return true;
        }
        tx.errorLevel = 0;
        return false;
    }

    public BucketHitMap getAndResetHitMap() {
        BucketHitMap b = this.hitmap;
        this.hitmap = !this.conf.hitview_enabled ? new BucketHitMap() : new BucketHitView();
        return b;
    }

    public static class BucketSimple {
        public int count;
        public long timesum;
        public int error;
    }
}

