/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter;

import whatap.lang.H1;
import whatap.util.MeteringUtil;

public class MeterTpsResp {
    private MeteringUtil<Bucket> meter = new MeteringUtil<Bucket>(){

        @Override
        protected Bucket create() {
            return new Bucket();
        }

        @Override
        protected void clear(Bucket o) {
            o.tps = 0.0;
            o.rtime = 0.0;
            o.count = 0;
        }
    };

    public synchronized void add(double tps, double rtime) {
        Bucket b = this.meter.getCurrentBucket();
        b.tps += tps;
        b.rtime += rtime;
        ++b.count;
    }

    public Bucket getAvg(int period) {
        final Bucket bk = new Bucket();
        this.meter.search(period, new H1<Bucket>(){

            @Override
            public void process(Bucket u) {
                bk.tps += u.tps;
                bk.rtime += u.rtime;
                bk.count += u.count;
            }
        });
        if (bk.count > 0) {
            bk.tps /= (double)bk.count;
            bk.rtime /= (double)bk.count;
        }
        return bk;
    }

    public int getCount(int period) {
        final Bucket bk = new Bucket();
        this.meter.search(period, new H1<Bucket>(){

            @Override
            public void process(Bucket u) {
                bk.count += u.count;
            }
        });
        return bk.count;
    }

    public static class Bucket {
        public double tps;
        public double rtime;
        public int count;
    }
}

