/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter;

import java.util.ArrayList;
import java.util.List;
import whatap.agent.Configure;
import whatap.agent.ContainerConf;
import whatap.agent.Logger;
import whatap.agent.ParamSecurity;
import whatap.agent.conf.ConfDebug;
import whatap.agent.conf.ConfLogSink;
import whatap.agent.conf.ConfOpenMx;
import whatap.agent.counter.Fix5SecCollector;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.collection.CollectionHolder;
import whatap.agent.counter.meter.BlockingDetect;
import whatap.agent.counter.task.AgentInfo;
import whatap.agent.counter.task.MeteringInfo;
import whatap.agent.counter.task.RealtimeUser;
import whatap.agent.counter.task.ResDBCount;
import whatap.agent.counter.task.ResProcCPU;
import whatap.agent.counter.task.ResProcFD;
import whatap.agent.counter.task.ResProcGC;
import whatap.agent.counter.task.ResProcHeap;
import whatap.agent.counter.task.ResSysCPU;
import whatap.agent.counter.task.ResThreadCount;
import whatap.agent.counter.task.ResWasThreadPool;
import whatap.agent.counter.task.ServiceActiveTransaction;
import whatap.agent.counter.task.ServiceHttpCall;
import whatap.agent.counter.task.ServiceSql;
import whatap.agent.counter.task.ServiceTransaction;
import whatap.agent.counter.task.ThreadDiskUsage;
import whatap.agent.data.DataPackSender;
import whatap.agent.net.TcpRequestMgr;
import whatap.agent.net.TcpSession;
import whatap.agent.open.OpenMxEng;
import whatap.agent.plugin.PluginExtraCounter;
import whatap.lang.pack.CounterPack1;
import whatap.lang.slog.SLog;
import whatap.logsink.fw.LogSenderThread;
import whatap.logsink.std.StdErrSenderThread;
import whatap.logsink.std.StdOutSenderThread;
import whatap.logsink.zip.ZipSendProxyThread;
import whatap.perfx.PerfXExecutor;
import whatap.util.AnsiPrint;
import whatap.util.DateUtil;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class CountCollector
extends Thread {
    private static CountCollector instance;
    protected List<ICounterTask> tasks = new ArrayList<ICounterTask>();
    private static final List<ICounterTask> pendingTasks;
    private static boolean initialized;
    public static ICounterTask customTask;

    public static final synchronized CountCollector getInstance() {
        if (instance == null) {
            instance = new CountCollector();
            instance.setName("WhaTap-CountCollector");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void run() {
        Configure conf = Configure.getInstance();
        conf.waitForInit();
        Fix5SecCollector.getInstance();
        long lastSysTime = DateUtil.nanoToMillis();
        initialized = false;
        int interval = conf.realtime_interval;
        long next = (long)interval + System.currentTimeMillis() / (long)interval * (long)interval;
        while (true) {
            long time;
            if ((interval = conf.realtime_interval) == 5000) {
                CountCollector.sleepx(interval / 1000);
                time = System.currentTimeMillis() / 5000L * 5000L;
            } else {
                long now = System.currentTimeMillis();
                while (now < next) {
                    ThreadUtil.sleep(100L);
                    now = System.currentTimeMillis();
                }
                time = now = now / (long)interval * (long)interval;
                next = time + (long)interval;
            }
            CounterPack1 pack = new CounterPack1();
            pack.time = time;
            pack.collect_interval_ms = DateUtil.nanoToMillis() - lastSysTime;
            pack.duration = (int)((pack.collect_interval_ms + 499L) / 1000L);
            pack.pid = SysJMX.getProcessPID();
            lastSysTime = DateUtil.nanoToMillis();
            if (pack.duration <= 0) continue;
            if (!initialized) {
                initialized = true;
                this.initTask();
            }
            if (conf.counter_enabled) {
                this.process(pack);
                this.processCustom(pack);
                PluginExtraCounter.process(pack);
            }
            try {
                LogSenderThread.getInstance().logSelf(pack);
                StdErrSenderThread.getInstance().logSelf(pack);
                StdOutSenderThread.getInstance().logSelf(pack);
                ZipSendProxyThread.getInstance().logSelf(pack);
                TcpRequestMgr.getInstance().logSelf(pack);
                DataPackSender.send(pack);
                long lastRecvTime = TcpSession.getLastRecvTime();
                if (ConfDebug.debug_counterpack_enabled && (CounterPack1.TRACE_WAITING_PACK_COUNT >= ConfDebug.debug_counterpack_factor || lastRecvTime >= ConfDebug.debug_counterpack_recvtime)) {
                    this.warning(lastRecvTime);
                }
            }
            catch (Throwable t) {
                Logger.println("A205", 10, t);
            }
            if (ConfOpenMx.openmx_enabled) {
                OpenMxEng.getInstasnce();
            }
            ParamSecurity.reload();
            ContainerConf.load();
            BlockingDetect.getInstance().save();
            PerfXExecutor.start();
            ThreadDiskUsage.startThread();
            CollectionHolder.gc();
        }
    }

    private void initTask() {
        try {
            this.tasks.add(new ServiceTransaction());
            this.tasks.add(new ServiceActiveTransaction());
            this.tasks.add(new RealtimeUser());
            this.tasks.add(new ResProcGC());
            this.tasks.add(new ResProcHeap());
            this.tasks.add(new ServiceHttpCall());
            this.tasks.add(new ResProcCPU());
            this.tasks.add(new ResSysCPU());
            this.tasks.add(new ServiceSql());
            this.tasks.add(new ResThreadCount());
            this.tasks.add(new AgentInfo());
            this.tasks.add(new ResDBCount());
            this.tasks.add(new ResWasThreadPool());
            this.tasks.add(new ResProcFD());
            this.tasks.add(new MeteringInfo());
            BlockingDetect.getInstance().load();
            if (ConfLogSink.logsink_stdout_enabled) {
                StdOutSenderThread.getInstance();
            }
            if (ConfLogSink.logsink_stderr_enabled) {
                StdErrSenderThread.getInstance();
            }
            for (ICounterTask task : pendingTasks) {
                this.tasks.add(task);
            }
            pendingTasks.clear();
        }
        catch (Throwable t) {
            Logger.println(this.getClass().getName(), t);
        }
    }

    public void registerTask(ICounterTask task) {
        if (task == null) {
            return;
        }
        if (!initialized) {
            pendingTasks.add(task);
        } else if (instance != null && CountCollector.instance.tasks != null) {
            CountCollector.instance.tasks.add(task);
        }
    }

    protected void processCustom(CounterPack1 pack) {
        Configure conf = Configure.getInstance();
        ICounterTask custom = customTask;
        if (conf.custom_task_enabled && custom != null) {
            try {
                custom.process(pack);
            }
            catch (Throwable e) {
                Logger.println("CountCollectorCustom", 10, e);
            }
        }
    }

    protected void warning(long lastRecvTime) {
        TcpRequestMgr tcpr = TcpRequestMgr.getInstance();
        SLog sb = new SLog();
        sb.red("id", "WARNING");
        sb.red("wait", CounterPack1.TRACE_WAITING_PACK_COUNT);
        if (tcpr.sendDropped1 > 0L) {
            sb.green("drop", tcpr.sendDropped1);
        }
        sb.a("q1-size", tcpr.getSizeQue1());
        sb.red("last-recvtime", lastRecvTime);
        sb.green("localport", TcpSession.connection_localport);
        sb.green("pid", SysJMX.getProcessPID());
        Logger.println(sb.str());
    }

    private void process(CounterPack1 pw) {
        for (int i = 0; i < this.tasks.size(); ++i) {
            try {
                ICounterTask task = this.tasks.get(i);
                task.process(pw);
                continue;
            }
            catch (Throwable t) {
                Logger.println("CountCollector", 10, t);
            }
        }
    }

    static void sleepx(int interval) {
        long lasttime = System.currentTimeMillis();
        ThreadUtil.sleep(2000L);
        while (true) {
            long nowtime;
            if ((nowtime = System.currentTimeMillis()) < lasttime) {
                if (nowtime - lasttime >= 3000L) {
                    Logger.println("TIMECHECK", 10, AnsiPrint.red("fatal warning time-reverse " + (nowtime - lasttime) + "ms"));
                } else if (Configure.getInstance().timecheck_print_enabled) {
                    Logger.println("TIMECHECK", 10, "warning time-reverse " + (nowtime - lasttime) + "ms");
                }
            }
            lasttime = nowtime;
            long now = DateUtil.currentTime() / 1000L;
            if (now == now / (long)interval * (long)interval) break;
            ThreadUtil.sleep(200L);
        }
    }

    private CountCollector() {
    }

    static {
        pendingTasks = new ArrayList<ICounterTask>();
        initialized = false;
        customTask = null;
    }
}

