/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control.dyna;

import java.util.HashSet;
import whatap.agent.JavaAgent;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.SortUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynaBCIHelper {
    static String[] startFilter = new String[]{"java.", "jdk.", "oshi.", "com.sun.", "sun.", "whatap.", "["};
    static String[] indexFilter = new String[]{"$$Lambda"};

    public static MapValue getTopPackage() {
        MapValue stringSet = new MapValue();
        if (JavaAgent.instrumentation == null) {
            return stringSet;
        }
        Class[] loadedClasses = JavaAgent.instrumentation.getAllLoadedClasses();
        if (loadedClasses == null) {
            return stringSet;
        }
        for (int i = 0; i < loadedClasses.length; ++i) {
            Class clazz = loadedClasses[i];
            if (DynaBCIHelper.isIgnore(clazz.getName())) continue;
            DynaBCIHelper.checkUnderTwoDepth(clazz.getName(), stringSet);
        }
        return stringSet;
    }

    private static void checkUnderTwoDepth(String class1, MapValue out) {
        int x = class1.indexOf(".");
        if (x > 0) {
            int y = class1.indexOf(46, x + 1);
            if (y < 0) {
                out.put(class1.substring(0, x), 1);
            } else {
                out.put(class1.substring(0, y), 2);
            }
        }
    }

    public static ListValue getPackageList(String top) {
        if (JavaAgent.instrumentation == null) {
            return new ListValue();
        }
        Class[] loadedClasses = JavaAgent.instrumentation.getAllLoadedClasses();
        if (loadedClasses == null) {
            return new ListValue();
        }
        HashSet<String> p = new HashSet<String>();
        if (!top.endsWith(".")) {
            top = top + ".";
        }
        for (int i = 0; i < loadedClasses.length; ++i) {
            String className;
            Class clazz = loadedClasses[i];
            if (clazz.isInterface() || clazz.isArray() || clazz.isAnonymousClass() || clazz.isEnum() || DynaBCIHelper.isIgnore(clazz.getName()) || !(className = clazz.getName()).startsWith(top)) continue;
            p.add(StringUtil.cutOut(className, '.'));
        }
        ListValue out = new ListValue();
        for (String i : SortUtil.sort_string(p.iterator(), p.size())) {
            out.add(i);
        }
        return out;
    }

    public static StringKeyLinkedMap<Boolean> getClassList(String pkgName) {
        StringKeyLinkedMap<Boolean> p = new StringKeyLinkedMap<Boolean>();
        if (JavaAgent.instrumentation == null) {
            return p;
        }
        Class[] loadedClasses = JavaAgent.instrumentation.getAllLoadedClasses();
        if (loadedClasses == null) {
            return p;
        }
        for (int i = 0; i < loadedClasses.length; ++i) {
            Class clazz = loadedClasses[i];
            if (clazz.isInterface() || clazz.isArray() || clazz.isAnonymousClass() || clazz.isEnum() || !clazz.getName().startsWith(pkgName)) continue;
            p.put(clazz.getName(), false);
        }
        return p;
    }

    private static boolean isIgnore(String name) {
        int i;
        for (i = 0; i < startFilter.length; ++i) {
            if (!name.startsWith(startFilter[i])) continue;
            return true;
        }
        for (i = 0; i < indexFilter.length; ++i) {
            if (name.indexOf(indexFilter[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public static MapValue toMap(StringKeyLinkedMap<Boolean> m) {
        MapValue out = new MapValue();
        StringEnumer en = m.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            out.put(key, m.get(key));
        }
        return out;
    }
}

