/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.conf;

import java.io.File;
import whatap.agent.Configure;
import whatap.util.FileUtil;
import whatap.util.IntSet;
import whatap.util.StringLinkedSet;
import whatap.util.StringUtil;

public class ConfThrottle {
    public static final int NOTICE_MESSAGE = 0;
    public static final int NOTICE_HTML = 1;
    public static final int NOTICE_FORWARD = 2;
    public static boolean throttle_enabled = false;
    public static int throttle_limit = 10000;
    public static IntSet throttle_target_urls = new IntSet();
    public static String throttle_passing_url = "";
    public static String throttle_passing_url_prefix = "";
    public static String throttle_blocking_url = "";
    public static String throttle_blocking_ip = "";
    public static String throttle_blocking_ignore_domain = "";
    public static String throttle_blocking_ignore_context = "";
    public static int throttle_rejected_mode = 0;
    public static String throttle_rejected_message = "too many request!!";
    public static String throttle_rejected_forward = "";
    public static HTML throttle_rejected_html = null;
    public static int throttle_blocked_mode = 0;
    public static String throttle_blocked_message = "request blocked!!";
    public static String throttle_blocked_forward = "";
    public static HTML throttle_blocked_html = null;
    public static boolean blocking_detect_enabled = false;
    public static int blocking_detect_time = 10000;
    public static int blocking_detect_count = 500;
    public static String blocking_detect_file = "blocking1.dat";
    public static String throttle_play2reject_classes = "";
    public static String throttle_play2reject_supers = "";
    public static String throttle_play2reject_interfaces = "";
    public static StringLinkedSet throttle_play2reject_ignore_methods = new StringLinkedSet();
    public static String throttle_rejected_forward_param = "";
    public static String throttle_rejected_html_content_type = "text/html";
    public static boolean reject_event_enabled = false;
    public static long reject_event_interval = 30000L;

    public static void apply(Configure conf) {
        throttle_enabled = conf.getBoolean("throttle_enabled", false);
        throttle_blocking_url = conf.getValue("throttle_blocking_url", "");
        throttle_blocking_ip = conf.getValue("throttle_blocking_ip", "");
        throttle_blocking_ignore_context = conf.getValue("throttle_blocking_ignore_context", "");
        throttle_blocking_ignore_domain = conf.getValue("throttle_blocking_ignore_domain", "");
        throttle_limit = conf.getInt("throttle_limit", 10000);
        throttle_target_urls = conf.getStringHashSet("throttle_target_urls", "", ",");
        throttle_passing_url = conf.getValue("throttle_passing_url", "");
        throttle_passing_url_prefix = conf.getValue("throttle_passing_url_prefix", "");
        throttle_rejected_message = conf.getValue("throttle_rejected_message", "too many request!!");
        throttle_rejected_forward = conf.getValue("throttle_rejected_forward", "");
        throttle_rejected_html = ConfThrottle.loadHtml(throttle_rejected_html, conf.getValue("throttle_rejected_html"));
        String def_forward = "";
        String def_html = null;
        String def_html_type = "text/html";
        if (StringUtil.isNotEmpty(throttle_rejected_forward)) {
            throttle_rejected_mode = 2;
            def_forward = throttle_rejected_forward;
        } else if (throttle_rejected_html != null && StringUtil.isNotEmpty(ConfThrottle.throttle_rejected_html.contents)) {
            throttle_rejected_mode = 1;
            def_html = ConfThrottle.throttle_rejected_html.name;
            if (def_html != null && def_html.endsWith(".json")) {
                def_html_type = "application/json";
            }
        } else {
            throttle_rejected_mode = 0;
        }
        throttle_rejected_forward_param = conf.getValue("throttle_rejected_forward_param", "");
        throttle_rejected_html_content_type = conf.getValue("throttle_rejected_html_content_type", def_html_type);
        throttle_blocked_message = conf.getValue("throttle_blocked_message", "request blocked!!");
        throttle_blocked_forward = conf.getValue("throttle_blocked_forward", def_forward);
        throttle_blocked_html = ConfThrottle.loadHtml(throttle_blocked_html, conf.getValue("throttle_blocked_html", def_html));
        throttle_blocked_mode = StringUtil.isNotEmpty(throttle_blocked_forward) ? 2 : (throttle_blocked_html != null && StringUtil.isNotEmpty(ConfThrottle.throttle_blocked_html.contents) ? 1 : 0);
        blocking_detect_enabled = conf.getBoolean("blocking_detect_enabled", false);
        blocking_detect_time = conf.getInt("blocking_detect_time", 10000);
        blocking_detect_count = conf.getInt("blocking_detect_count", 500);
        blocking_detect_file = conf.getValue("blocking_detect_file", "blocking1.dat");
        throttle_play2reject_classes = conf.getValue("throttle_play2reject_classes", "");
        throttle_play2reject_supers = conf.getValue("throttle_play2reject_supers", "");
        throttle_play2reject_interfaces = conf.getValue("throttle_play2reject_interfaces", "");
        throttle_play2reject_ignore_methods = conf.getStringSet("throttle_play2reject_ignore_methods", "", ",");
        reject_event_interval = conf.getLong("reject_event_interval", 30000L);
        reject_event_enabled = conf.getBoolean("reject_event_enabled", false);
    }

    private static HTML loadHtml(HTML old, String fname) {
        if (fname == null) {
            return null;
        }
        File file = new File(Configure.getHomeDir(), fname);
        if (!file.exists()) {
            return null;
        }
        if (old == null || !old.name.equals(fname) || old.modified < file.lastModified()) {
            HTML html = new HTML(fname, file.lastModified());
            byte[] contents = FileUtil.readAll(file);
            if (contents != null) {
                html.contents = new String(contents);
            }
            return html;
        }
        return old;
    }

    public static class HTML {
        public String name;
        public long modified;
        public String contents;

        public HTML(String path, long modified) {
            this.name = path;
            this.modified = modified;
        }
    }
}

