/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.boot;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import whatap.agent.Logger;
import whatap.util.CastUtil;
import whatap.util.StringUtil;

public class ServicePortFinder {
    static int errorCount = 10;

    public static int search(int type) {
        int port = CastUtil.cint(System.getProperty("whatap.web.port", System.getenv("WHATAP_WEB_PORT")));
        if (port > 0) {
            return port;
        }
        switch (type) {
            case 13: {
                return ServicePortFinder.getSpringBootTomcatServicePort();
            }
            case 1: {
                return ServicePortFinder.getTomcatServicePort();
            }
            case 2: {
                return ServicePortFinder.getJBossServicePort();
            }
            case 8: {
                return ServicePortFinder.getWebLogicListenPort();
            }
        }
        return -1;
    }

    public static int getSpringBootTomcatServicePort() {
        int port;
        block5: {
            String catalinaBase = System.getProperty("catalina.base");
            port = 0;
            try {
                String[] parts;
                String lastPart;
                if (catalinaBase == null || catalinaBase.isEmpty() || !(lastPart = StringUtil.lastWord(catalinaBase, "/")).startsWith("tomcat") || (parts = lastPart.split("\\.")).length < 3) break block5;
                for (int i = 1; i <= 2; ++i) {
                    try {
                        int num = Integer.parseInt(parts[i]);
                        if (num <= 0) continue;
                        port = num;
                        return port;
                    }
                    catch (NumberFormatException e) {
                        if (errorCount-- < 0) continue;
                        Logger.println("service port", e);
                    }
                }
            }
            catch (Throwable t) {
                if (errorCount-- < 0) break block5;
                Logger.println("service port", t);
            }
        }
        return port;
    }

    public static int getTomcatServicePort() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        int port = 0;
        try {
            Set<ObjectName> objSet = server.queryNames(null, new ObjectName("*:type=Connector,*"));
            for (ObjectName oi : objSet) {
                Object o = server.getAttribute(oi, "port");
                port = Math.max(port, CastUtil.cint(o));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public static int getJBossServicePort() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String jboss_version = null;
        int port = 0;
        try {
            ObjectName oi = new ObjectName("jboss.ws:service=ServerConfig");
            Object o = server.getAttribute(oi, "WebServicePort");
            port = Math.max(port, CastUtil.cint(o));
            o = server.getAttribute(oi, "ImplementationVersion");
            jboss_version = CastUtil.cString(o);
        }
        catch (Exception e) {
            System.setProperty("whatap.error", "" + e);
        }
        if (jboss_version != null) {
            System.setProperty("whatap.jboss.version", jboss_version);
        }
        return port;
    }

    public static int getWebLogicListenPort() {
        int port = CastUtil.cint(System.getProperty("weblogic.ListenPort"));
        if (port > 0) {
            return port;
        }
        String serverName = System.getProperty("weblogic.Name");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName oi = new ObjectName("com.bea:Name=" + serverName + ",Type=Server");
            Object o = server.getAttribute(oi, "ListenPort");
            return CastUtil.cint(o);
        }
        catch (Throwable e) {
            System.setProperty("whatap.error", e.getMessage());
            return port;
        }
    }

    public static void main(String[] args) {
        List<String> o = ManagementFactory.getRuntimeMXBean().getInputArguments();
        System.out.println(o);
    }
}

