/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.api.trace.TxMethod;
import whatap.agent.api.trace.TxMethodCtx;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.org.objectweb.asm.Label;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

class MethodCompomentMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACE_CLASS = TxMethod.class.getName().replace('.', '/');
    private static final String START_METHOD = "startComponent";
    private static final String START_SIGNATURE = "(ILjava/lang/String;)Lwhatap/agent/api/trace/TxMethodCtx;";
    private static final String END_METHOD = "endComponent";
    private static final String END_SIGNATURE = "(Lwhatap/agent/api/trace/TxMethodCtx;Ljava/lang/Throwable;)V";
    private final int compHash;
    private final String compName;
    private final Label startFinally = new Label();
    private int statIdx = -1;

    public MethodCompomentMV(int access, String desc, MethodVisitor mv, int compHash, String compName) {
        super(IASM.API, access, desc, mv);
        this.compName = compName;
        this.compHash = compHash;
    }

    public void visitCode() {
        AsmUtil.PUSH(this.mv, this.compHash);
        this.mv.visitLdcInsn(this.compName);
        this.mv.visitMethodInsn(184, TRACE_CLASS, START_METHOD, START_SIGNATURE, false);
        this.statIdx = this.newLocal(Type.getType(TxMethodCtx.class));
        this.mv.visitVarInsn(58, this.statIdx);
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177 && this.statIdx >= 0) {
            this.mv.visitVarInsn(25, this.statIdx);
            this.mv.visitInsn(1);
            this.mv.visitMethodInsn(184, TRACE_CLASS, END_METHOD, END_SIGNATURE, false);
        }
        this.mv.visitInsn(opcode);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitVarInsn(25, this.statIdx);
        this.mv.visitVarInsn(25, errIdx);
        this.mv.visitMethodInsn(184, TRACE_CLASS, END_METHOD, END_SIGNATURE, false);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }
}

