/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashSet;
import whatap.agent.ClassDesc;
import whatap.agent.asm.IASM;
import whatap.agent.asm.JDBCConnectionNativeCV;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class JDBCConnectionNativeASM
extends IASM
implements Opcodes {
    public final HashSet<String> target = HookingSet.getHookingClassSet(ConfHook.hook_connection_native_classes);

    public JDBCConnectionNativeASM() {
        if (!ConfHook.hook_connection_native_default_enabled) {
            return;
        }
        this.target.add("org/postgresql/jdbc2/AbstractJdbc2Connection");
        this.target.add("oracle/jdbc/driver/PhysicalConnection");
        this.target.add("org/mariadb/jdbc/Connection");
        this.target.add("org/mariadb/jdbc/MySQLConnection");
        this.target.add("org/mariadb/jdbc/MariaDbConnection");
        this.target.add("com/mysql/jdbc/Connection");
        this.target.add("com/mysql/cj/jdbc/ConnectionImpl");
        this.target.add("software/aws/rds/jdbc/mysql/shading/com/mysql/cj/jdbc/ConnectionImpl");
        this.target.add("org/postgresql/jdbc/PgConnection");
        this.target.add("com/tmax/tibero/jdbc/driver/TbConnection");
        this.target.add("com/microsoft/sqlserver/jdbc/SQLServerConnection");
        this.target.add("com/ibm/db2/jcc/am/Connection");
        this.target.add("jdbc/FakeConnection");
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_db_native_enabled) {
            return cv;
        }
        if (this.target.contains(className)) {
            return new JDBCConnectionNativeCV(cv, className);
        }
        return cv;
    }
}

