/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.DynaMethodMV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.control.dyna.DynaBCIMethod;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.HashUtil;

class DynaMethodCV
extends ClassVisitor
implements Opcodes {
    public String className;

    public DynaMethodCV(ClassVisitor cv, String className) {
        super(IASM.API, cv);
        this.className = className;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || AsmUtil.isInitMethod(name)) {
            return mv;
        }
        switch (access & 7) {
            case 1: {
                if (DynaBCIMethod.isPublic) break;
                return mv;
            }
            case 4: {
                if (DynaBCIMethod.isProtected) break;
                return mv;
            }
            case 2: {
                if (DynaBCIMethod.isPrivate) break;
                return mv;
            }
            default: {
                if (DynaBCIMethod.isNone) break;
                return mv;
            }
        }
        String fullname = AsmUtil.makeClassAndMethod(this.className, name);
        int fullname_hash = HashUtil.hash(fullname);
        return new DynaMethodMV(access, desc, mv, fullname, fullname_hash);
    }
}

