/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.BlobValue;
import whatap.util.AnsiPrint;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;
import whatap.util.cardinality.HyperLogLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTool {
    public static StringKeyLinkedMap<HyperLogLog> userEntry = UserTool.create();
    private static long lasttime = 0L;
    private static boolean debug = false;

    public static void add(String key, String userid) {
        if (key == null || userid == null) {
            return;
        }
        UserTool.add(key, HashUtil.hash(userid));
    }

    public static void add(String key, int userid) {
        UserTool.add(key, (long)userid);
    }

    public static void add(String key, long userid) {
        if (userid != 0L) {
            userEntry.intern(key).offer(userid);
        }
    }

    private static StringKeyLinkedMap<HyperLogLog> create() {
        return new StringKeyLinkedMap<HyperLogLog>(){

            @Override
            protected HyperLogLog create(String key) {
                return new HyperLogLog();
            }
        };
    }

    public static void send1m(String category) {
        long now = DateUtil.now();
        if (lasttime >= (now = now / 60000L * 60000L)) {
            return;
        }
        lasttime = now;
        UserTool._send(category);
    }

    public static void send5m(String category) {
        long now = DateUtil.now();
        if (lasttime >= (now = now / 300000L * 300000L)) {
            return;
        }
        lasttime = now;
        UserTool._send(category);
    }

    public static void send(String category) {
        UserTool._send(category);
    }

    public static void debug(boolean b) {
        debug = b;
    }

    private static synchronized void _send(String category) {
        if (userEntry.isEmpty()) {
            return;
        }
        SecurityMaster secu = SecurityMaster.getInstance();
        TagCountPack p = new TagCountPack();
        p.category = category;
        p.time = DateUtil.now() / 5000L * 5000L;
        Configure conf = Configure.getInstance();
        if (StringUtil.isNotEmpty(conf.OKIND_NAME)) {
            p.putTag("okindName", conf.OKIND_NAME);
        }
        p.putTag("oname", secu.ONAME);
        StringKeyLinkedMap<HyperLogLog> m = userEntry;
        userEntry = UserTool.create();
        StringEnumer en = m.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            HyperLogLog hlog = m.get(key);
            p.put("n_" + key, hlog.cardinality());
            p.put(key, new BlobValue(hlog.getBytes()));
        }
        DataPackSender.send(p);
        if (debug) {
            Logger.println("USER-TOOL", AnsiPrint.green(p.toString()));
        }
    }
}

