/*
 * Decompiled with CFR 0.152.
 */
package whatap.v1.work;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.util.IPUtil;
import whatap.util.StopWatch;
import whatap.util.StringUtil;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;
import whatap.v1.ITask;
import whatap.v1.TaskResult;

public class TaskWrap
implements Runnable {
    public long _start_time_;
    public long _next_time_;
    public long _interval_;
    public boolean exactTime;
    public boolean running;
    public String category;
    public ITask handler;
    public int error;
    public boolean debug_enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object sw;
        try {
            TaskWrap taskWrap = this;
            synchronized (taskWrap) {
                this.running = true;
            }
            sw = new StopWatch();
            TaskResult m = new TaskResult();
            this.handler.process(m);
            if (this.debug_enabled) {
                Logger.println("API-TASK", "name=" + this.category + " executed size=" + m.pack.size() + " " + ((StopWatch)sw).getTime() + "ms");
            }
            if (m.pack.size() > 0) {
                this.setTagAgentInfo(m.pack);
                DataPackSender.sendOneWay(m.pack, m.fastflush);
            }
        }
        catch (Throwable t) {
            if (this.error < 5) {
                ++this.error;
                String msg = "<" + this.error + "> " + ThreadUtil.getStackTrace(t);
                this.log(msg);
            }
        }
        finally {
            sw = this;
            synchronized (sw) {
                this.running = false;
            }
        }
    }

    protected void log(String msg) {
        Logger.println("API-TASK", msg);
    }

    private void setTagAgentInfo(TagCountPack p) {
        Configure conf = Configure.getInstance();
        SecurityMaster secu = SecurityMaster.getInstance();
        p.time = this._next_time_;
        p.category = this.category;
        p.putTag("oname", secu.ONAME);
        if (StringUtil.isNotEmpty(conf.ONODE_NAME)) {
            p.putTag("onodeName", conf.ONODE_NAME);
        }
        if (StringUtil.isNotEmpty(conf.OKIND_NAME)) {
            p.putTag("okindName", conf.OKIND_NAME);
        }
        String ip = IPUtil.toString(SecurityMaster.getInstance().IP);
        p.putTag("ip", ip);
        p.putTag("hostname", SysJMX.getHostName());
        p.putTag("pid", SysJMX.getProcessPID());
    }

    public long delayedTime() {
        long now = System.currentTimeMillis();
        if (now > this._next_time_) {
            return now - this._next_time_;
        }
        return 0L;
    }
}

