/*
 * Decompiled with CFR 0.152.
 */
package whatap.util.expr.function;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import whatap.util.expr.Function;
import whatap.util.expr.function.ArrayParamUtil;

public class Avg
implements Function {
    public Object process(List param) throws RuntimeException {
        if (param == null) {
            return new Double(0.0);
        }
        double d = 0.0;
        int cnt = 0;
        try {
            for (int i = 0; i < param.size(); ++i) {
                Object o = param.get(i);
                if (o == null) continue;
                if (o instanceof List) {
                    d += ArrayParamUtil.sum((List)o);
                    cnt += ((List)o).size();
                    continue;
                }
                if (o instanceof Map) {
                    d += ArrayParamUtil.sum((Map)o);
                    cnt += ((Map)o).size();
                    continue;
                }
                if (o.getClass().isArray()) {
                    d += ArrayParamUtil.sumArr(o);
                    cnt += Array.getLength(o);
                    continue;
                }
                d += ArrayParamUtil.getDouble(o);
                ++cnt;
            }
            return cnt == 0 ? 0.0 : new Double(d / (double)cnt);
        }
        catch (Exception e) {
            throw new RuntimeException("formula function : " + e);
        }
    }
}

