/*
 * Decompiled with CFR 0.152.
 */
package whatap.util.expr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;
import whatap.util.Stack;
import whatap.util.StrMatch;
import whatap.util.StringUtil;
import whatap.util.expr.ExprParser;
import whatap.util.expr.Function;
import whatap.util.expr.FunctionLoader;
import whatap.util.expr.YyToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expr {
    private String ruleString = null;
    private Stack<YyToken> yyTokens;

    public Expr(String rule) throws RuntimeException {
        this.ruleString = rule;
        this.yyTokens = new ExprParser().parse(rule);
    }

    public Object execute() throws RuntimeException {
        return this.execute(null);
    }

    public boolean checkVars(Set<String> param) {
        for (int i = 0; i < this.yyTokens.size(); ++i) {
            if (((YyToken)this.yyTokens.get((int)i)).index != 120 || param.contains(((YyToken)this.yyTokens.get((int)i)).value)) continue;
            return false;
        }
        return true;
    }

    public Set<String> getVarSet() {
        HashSet<String> vars = new HashSet<String>();
        for (int i = 0; i < this.yyTokens.size(); ++i) {
            if (((YyToken)this.yyTokens.get((int)i)).index != 120) continue;
            vars.add((String)((YyToken)this.yyTokens.get((int)i)).value);
        }
        return vars;
    }

    public static boolean check(String formula) {
        try {
            if (StringUtil.isEmpty(formula)) {
                return false;
            }
            new ExprParser().parse(formula);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object execute(Object param) throws RuntimeException {
        YyToken yyToken;
        Stack tokList = (Stack)this.yyTokens.clone();
        Stack<YyToken> stack = new Stack<YyToken>();
        if (tokList.size() == 1) {
            yyToken = (YyToken)tokList.pop();
            switch (yyToken.index) {
                case 120: {
                    yyToken = this.getParamValue((String)yyToken.value, param);
                }
            }
            tokList.push(yyToken);
        } else {
            block15: while (tokList.size() > 1) {
                yyToken = (YyToken)tokList.pop();
                YyToken temp = null;
                YyToken operand1 = null;
                YyToken operand2 = null;
                if (yyToken.index < 100) {
                    if (tokList.size() < 2) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    if (yyToken.index == 91) {
                        ArrayList<Object> opList = new ArrayList<Object>();
                        ArrayList<YyToken> tmpList = new ArrayList<YyToken>();
                        operand2 = (YyToken)tokList.pop();
                        while (operand2.index != 1002) {
                            if (operand2.index < 100) {
                                tokList.push(operand2);
                                stack.push(yyToken);
                                Iterator i = tmpList.iterator();
                                while (i.hasNext()) {
                                    stack.push((YyToken)i.next());
                                }
                                continue block15;
                            }
                            if (operand2.index < 1001) {
                                switch (operand2.index) {
                                    case 120: {
                                        operand2 = this.getParamValue((String)operand2.value, param);
                                    }
                                }
                                if (operand2.index == 105 && operand2.value instanceof Collection) {
                                    opList.addAll((Collection)operand2.value);
                                } else if (operand2.index == 101) {
                                    opList.add(null);
                                } else {
                                    opList.add(operand2.value);
                                }
                            }
                            tmpList.add(operand2);
                            if (tokList.isEmpty()) {
                                throw new RuntimeException("Unknown formula error");
                            }
                            operand2 = (YyToken)tokList.pop();
                        }
                        temp = this.operate_func(yyToken, opList);
                    } else {
                        operand1 = (YyToken)tokList.pop();
                        switch (operand1.index) {
                            case 120: {
                                operand1 = this.getParamValue((String)operand1.value, param);
                            }
                        }
                        if (operand1.index < 100) {
                            tokList.push(operand1);
                            stack.push(yyToken);
                            continue;
                        }
                        if (yyToken.index == 41 && "true".equals(operand1.value.toString()) || yyToken.index == 40 && "false".equals(operand1.value.toString())) {
                            if (stack.isEmpty()) {
                                return (Boolean)operand1.value;
                            }
                            this.dropNextOperand(tokList);
                            tokList.push(new YyToken(102, operand1.value));
                        }
                        if (yyToken.index == 42) {
                            YyToken token2 = (YyToken)tokList.pop();
                            if (token2.index != 43) {
                                throw new RuntimeException("Unknown formula error");
                            }
                            operand2 = (YyToken)tokList.pop();
                            if (operand2.index < 100) {
                                tokList.push(operand2);
                                stack.push(yyToken);
                                stack.push(operand1);
                                stack.push(token2);
                                continue;
                            }
                            if ("true".equals(operand1.value.toString())) {
                                temp = operand2;
                                this.dropNextOperand(tokList);
                            } else {
                                YyToken operand3 = (YyToken)tokList.pop();
                                if (operand3.index < 100) {
                                    tokList.push(operand3);
                                    stack.push(yyToken);
                                    stack.push(operand1);
                                    stack.push(token2);
                                    stack.push(operand2);
                                    continue;
                                }
                                temp = this.operate3(operand1, operand2, operand3);
                            }
                            switch (temp.index) {
                                case 120: {
                                    temp = this.getParamValue((String)temp.value, param);
                                }
                            }
                        } else {
                            operand2 = (YyToken)tokList.pop();
                            switch (operand2.index) {
                                case 120: {
                                    operand2 = this.getParamValue((String)operand2.value, param);
                                }
                            }
                            if (operand2.index < 100) {
                                tokList.push(operand2);
                                stack.push(yyToken);
                                stack.push(operand1);
                                continue;
                            }
                            temp = this.operate(operand1, operand2, yyToken);
                        }
                    }
                    tokList.push(temp);
                    while (!stack.isEmpty()) {
                        tokList.push(stack.pop());
                    }
                    continue;
                }
                throw new RuntimeException("Unknown formula error");
            }
        }
        if (tokList.size() == 1) {
            YyToken result = (YyToken)tokList.pop();
            if (result.index == 101) {
                return null;
            }
            return result.value;
        }
        throw new RuntimeException("Unknown formula error");
    }

    private void dropNextOperand(Stack<YyToken> tokenList) throws RuntimeException {
        int dropCnt = 1;
        do {
            if (tokenList.isEmpty()) {
                throw new RuntimeException("Unknown formula error");
            }
            YyToken yyToken = tokenList.pop();
            if (yyToken.index == 91) continue;
            if (yyToken.index < 100) {
                ++dropCnt;
                continue;
            }
            if (yyToken.index == 1001) {
                int count = 1;
                while (count > 0) {
                    if (tokenList.isEmpty()) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    yyToken = tokenList.pop();
                    if (yyToken.index == 1002) {
                        --count;
                        continue;
                    }
                    if (yyToken.index != 1001) continue;
                    ++count;
                }
            }
            --dropCnt;
        } while (dropCnt > 0);
    }

    private YyToken getParamValue(String key, Object param) throws RuntimeException {
        if (param instanceof Map) {
            return this.getParamValue(key, (Map)param);
        }
        if (param instanceof MapValue) {
            return this.getParamValue(key, (MapValue)param);
        }
        return this.value2token(param);
    }

    private YyToken getParamValue(String key, Map<String, ?> param) throws RuntimeException {
        if (param == null) {
            throw new RuntimeException("parameter is null");
        }
        Object o = param.get(key);
        if (o instanceof Value) {
            return this.value2token((Value)o);
        }
        return this.value2token(o);
    }

    private YyToken getParamValue(String key, MapValue param) throws RuntimeException {
        if (param == null) {
            throw new RuntimeException("parameter is null");
        }
        Value o = param.get(key);
        return this.value2token(o);
    }

    private YyToken operate(YyToken operand1, YyToken operand2, YyToken operator) throws RuntimeException {
        try {
            switch (operator.index) {
                case 0: {
                    if (operand1.index == 101 || operand2.index == 101) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    if (operand1.index == 104 || operand2.index == 104) {
                        double opr1 = ((Number)operand1.value).doubleValue();
                        double opr2 = ((Number)operand2.value).doubleValue();
                        return new YyToken(104, new Double(opr1 * opr2));
                    }
                    long opr1 = ((Number)operand1.value).longValue();
                    long opr2 = ((Number)operand2.value).longValue();
                    return new YyToken(103, new Long(opr1 * opr2));
                }
                case 1: {
                    if (operand1.index == 101 || operand2.index == 101) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    if (operand1.index == 104 || operand2.index == 104) {
                        double opr1 = ((Number)operand1.value).doubleValue();
                        double opr2 = ((Number)operand2.value).doubleValue();
                        if (opr2 == 0.0) {
                            throw new RuntimeException("Unknown formula error");
                        }
                        return new YyToken(104, new Double(opr1 / opr2));
                    }
                    long opr1 = ((Number)operand1.value).longValue();
                    long opr2 = ((Number)operand2.value).longValue();
                    if (opr2 == 0L) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    return new YyToken(103, new Long(opr1 / opr2));
                }
                case 2: {
                    if (operand1.index == 101 || operand2.index == 101) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    long opr1 = ((Number)operand1.value).longValue();
                    long opr2 = ((Number)operand2.value).longValue();
                    if (opr2 == 0L) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    return new YyToken(103, new Long(opr1 % opr2));
                }
                case 10: {
                    if (operand1.index == 106 || operand2.index == 106) {
                        return new YyToken(106, "" + operand1.value + operand2.value);
                    }
                    if (operand1.index == 104 || operand2.index == 104) {
                        double opr1 = ((Number)operand1.value).doubleValue();
                        double opr2 = ((Number)operand2.value).doubleValue();
                        return new YyToken(104, new Double(opr1 + opr2));
                    }
                    long opr1 = ((Number)operand1.value).longValue();
                    long opr2 = ((Number)operand2.value).longValue();
                    return new YyToken(103, new Long(opr1 + opr2));
                }
                case 11: {
                    if (operand1.index == 101 || operand2.index == 101) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    if (operand1.index == 104 || operand2.index == 104) {
                        double opr1 = ((Number)operand1.value).doubleValue();
                        double opr2 = ((Number)operand2.value).doubleValue();
                        return new YyToken(104, new Double(opr1 - opr2));
                    }
                    if (operand1.index == 106 || operand2.index == 106) {
                        String s = operand1.value.toString();
                        String delims = operand2.value.toString();
                        StringBuffer sb = new StringBuffer();
                        StringTokenizer st = new StringTokenizer(s, delims);
                        while (st.hasMoreTokens()) {
                            sb.append(st.nextToken());
                        }
                        return new YyToken(106, sb.toString());
                    }
                    long opr1 = ((Number)operand1.value).longValue();
                    long opr2 = ((Number)operand2.value).longValue();
                    return new YyToken(103, new Long(opr1 - opr2));
                }
                case 20: {
                    if (operand1.index == 101 || operand2.index == 101) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    if (!(operand1.index != 103 && operand1.index != 104 || operand2.index != 103 && operand2.index != 104)) {
                        double opr2;
                        double opr1 = ((Number)operand1.value).doubleValue();
                        return new YyToken(102, new Boolean(opr1 < (opr2 = ((Number)operand2.value).doubleValue())));
                    }
                    int comp = operand1.value.toString().compareTo(operand2.value.toString());
                    return new YyToken(102, new Boolean(comp < 0));
                }
                case 21: {
                    if (operand1.index == 101 || operand2.index == 101) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    if (!(operand1.index != 103 && operand1.index != 104 || operand2.index != 103 && operand2.index != 104)) {
                        double opr2;
                        double opr1 = ((Number)operand1.value).doubleValue();
                        return new YyToken(102, new Boolean(opr1 > (opr2 = ((Number)operand2.value).doubleValue())));
                    }
                    int comp = operand1.value.toString().compareTo(operand2.value.toString());
                    return new YyToken(102, new Boolean(comp > 0));
                }
                case 22: {
                    if (operand1.index == 101 || operand2.index == 101) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    if (!(operand1.index != 103 && operand1.index != 104 || operand2.index != 103 && operand2.index != 104)) {
                        double opr2;
                        double opr1 = ((Number)operand1.value).doubleValue();
                        return new YyToken(102, new Boolean(opr1 <= (opr2 = ((Number)operand2.value).doubleValue())));
                    }
                    int comp = operand1.value.toString().compareTo(operand2.value.toString());
                    return new YyToken(102, new Boolean(comp <= 0));
                }
                case 23: {
                    if (operand1.index == 101 || operand2.index == 101) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    if (!(operand1.index != 103 && operand1.index != 104 || operand2.index != 103 && operand2.index != 104)) {
                        double opr2;
                        double opr1 = ((Number)operand1.value).doubleValue();
                        return new YyToken(102, new Boolean(opr1 >= (opr2 = ((Number)operand2.value).doubleValue())));
                    }
                    int comp = operand1.value.toString().compareTo(operand2.value.toString());
                    return new YyToken(102, new Boolean(comp >= 0));
                }
                case 30: {
                    String opr2;
                    if (operand1.index == 101 && operand2.index == 101) {
                        return new YyToken(102, new Boolean(true));
                    }
                    if (operand1.index == 101 || operand2.index == 101) {
                        return new YyToken(102, new Boolean(false));
                    }
                    if (!(operand1.index != 103 && operand1.index != 104 || operand2.index != 103 && operand2.index != 104)) {
                        double opr22;
                        double opr1 = ((Number)operand1.value).doubleValue();
                        return new YyToken(102, new Boolean(opr1 == (opr22 = ((Number)operand2.value).doubleValue())));
                    }
                    String opr1 = operand1.value.toString();
                    int comp = opr1.compareTo(opr2 = operand2.value.toString());
                    return new YyToken(102, new Boolean(comp == 0));
                }
                case 31: {
                    String opr2;
                    if (operand1.index == 101 && operand2.index == 101) {
                        return new YyToken(102, new Boolean(false));
                    }
                    if (operand1.index == 101 || operand2.index == 101) {
                        return new YyToken(102, new Boolean(true));
                    }
                    if (!(operand1.index != 103 && operand1.index != 104 || operand2.index != 103 && operand2.index != 104)) {
                        double opr23;
                        double opr1 = ((Number)operand1.value).doubleValue();
                        return new YyToken(102, new Boolean(opr1 != (opr23 = ((Number)operand2.value).doubleValue())));
                    }
                    String opr1 = operand1.value.toString();
                    int comp = opr1.compareTo(opr2 = operand2.value.toString());
                    return new YyToken(102, new Boolean(comp != 0));
                }
                case 32: {
                    if (operand1.index == 101 && operand2.index == 101) {
                        return new YyToken(102, Boolean.TRUE);
                    }
                    if (operand1.index == 101 || operand2.index == 101) {
                        return new YyToken(102, Boolean.FALSE);
                    }
                    String opr1 = operand1.value.toString();
                    String opr2 = operand2.value.toString();
                    StrMatch m = StrMatch.createForLikeOperator(opr2);
                    return new YyToken(102, m.include(opr1));
                }
                case 40: {
                    if (operand1.index == 101 || operand2.index == 101) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    if (operand1.index == 102 && operand2.index == 102) {
                        boolean opr1 = (Boolean)operand1.value;
                        boolean opr2 = (Boolean)operand2.value;
                        return new YyToken(102, new Boolean(opr1 && opr2));
                    }
                    throw new RuntimeException("Unknown formula error");
                }
                case 41: {
                    if (operand1.index == 101 || operand2.index == 101) {
                        throw new RuntimeException("Unknown formula error");
                    }
                    if (operand1.index == 102 && operand2.index == 102) {
                        boolean opr1 = (Boolean)operand1.value;
                        boolean opr2 = (Boolean)operand2.value;
                        return new YyToken(102, new Boolean(opr1 || opr2));
                    }
                    throw new RuntimeException("Unknown formula error");
                }
            }
            throw new RuntimeException("Unknown formula error");
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown formula error");
        }
    }

    private YyToken operate_func(YyToken yyToken, List<?> params) throws RuntimeException {
        Function fobj = FunctionLoader.getFunction((String)yyToken.value);
        if (fobj == null) {
            throw new RuntimeException("unknown function name " + yyToken.value);
        }
        Object o = fobj.process(params);
        return this.value2token(o);
    }

    private YyToken operate3(YyToken operand1, YyToken operand2, YyToken operand3) throws RuntimeException {
        if (operand1.value == null) {
            throw new RuntimeException("Unknown formula error");
        }
        try {
            boolean opr1 = (Boolean)operand1.value;
            return opr1 ? operand2 : operand3;
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown formula error");
        }
    }

    private YyToken value2token(Object value) {
        if (value == null) {
            return new YyToken(101, "null");
        }
        if (value instanceof Double || value instanceof Float) {
            return new YyToken(104, value);
        }
        if (value instanceof Integer || value instanceof Long) {
            return new YyToken(103, value);
        }
        if (value instanceof Boolean) {
            return new YyToken(102, value);
        }
        if (value instanceof String) {
            return new YyToken(106, value);
        }
        return new YyToken(105, value);
    }

    private YyToken value2token(Value value) {
        if (value == null) {
            return new YyToken(101, "null");
        }
        switch (value.getValueType()) {
            case 0: {
                return new YyToken(101, "null");
            }
            case 10: {
                return new YyToken(102, value.toJavaObject());
            }
            case 20: {
                return new YyToken(103, value.toJavaObject());
            }
            case 30: 
            case 40: {
                return new YyToken(104, value.toJavaObject());
            }
            case 50: {
                return new YyToken(106, value.toJavaObject());
            }
            case 60: 
            case 70: 
            case 80: {
                return new YyToken(105, value.toJavaObject());
            }
        }
        throw new RuntimeException("unknown value type=" + value.getValueType());
    }

    public String toString() {
        return this.ruleString;
    }
}

