/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.BitUtil;
import whatap.util.CompareUtil;
import whatap.util.IntEnumer;
import whatap.util.LongEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongIntMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private LongIntEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;

    public LongIntMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public LongIntMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new LongIntEntry[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public LongIntMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized LongEnumer keys() {
        return new Enumer(1);
    }

    public synchronized IntEnumer values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<LongIntEntry> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsValue(int value) {
        LongIntEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            LongIntEntry e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(long key) {
        LongIntEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongIntEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    private int hash(long key) {
        return (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
    }

    public synchronized int get(long key) {
        LongIntEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongIntEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return this.NONE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LongIntEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LongIntEntry[] newMap = new LongIntEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            LongIntEntry old = oldMap[i];
            while (old != null) {
                LongIntEntry e = old;
                old = old.next;
                int index = this.hash(e.key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized long[] keyArray() {
        long[] _keys = new long[this.size()];
        LongEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextLong();
        }
        return _keys;
    }

    public synchronized int[] valueArray() {
        int[] _values = new int[this.size()];
        IntEnumer en = this.values();
        for (int i = 0; i < _values.length; ++i) {
            _values[i] = en.nextInt();
        }
        return _values;
    }

    public synchronized int add(long key, int value) {
        LongIntEntry[] tab = this.table;
        int _hash = this.hash(key);
        int index = _hash % tab.length;
        LongIntEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                e.value += value;
                return e.value;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = _hash % tab.length;
        }
        tab[index] = e = new LongIntEntry(key, value, tab[index]);
        ++this.count;
        return value;
    }

    public synchronized int addIfExist(long key, int value) {
        LongIntEntry[] tab = this.table;
        int _hash = this.hash(key);
        int index = _hash % tab.length;
        LongIntEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                e.value += value;
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    public synchronized int put(long key, int value) {
        LongIntEntry[] tab = this.table;
        int _hash = this.hash(key);
        int index = _hash % tab.length;
        LongIntEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                int old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = _hash % tab.length;
        }
        tab[index] = e = new LongIntEntry(key, value, tab[index]);
        ++this.count;
        return this.NONE;
    }

    public synchronized int remove(long key) {
        LongIntEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongIntEntry e = tab[index];
        LongIntEntry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                int oldValue = e.value;
                e.value = this.NONE;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized void clear() {
        LongIntEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongIntEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            LongIntEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongIntEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            LongIntEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public void putAll(LongIntMap other) {
        Enumeration<LongIntEntry> it = other.entries();
        int max = other.size();
        for (int i = 0; i <= max; ++i) {
            LongIntEntry e = it.nextElement();
            this.put(e.getKey(), e.getValue());
        }
    }

    public void toBytes(DataOutputX dout) {
        dout.writeDecimal(this.size());
        Enumeration<LongIntEntry> en = this.entries();
        while (en.hasMoreElements()) {
            LongIntEntry e = en.nextElement();
            dout.writeDecimal(e.getKey());
            dout.writeDecimal(e.getValue());
        }
    }

    public LongIntMap toObject(DataInputX in) {
        int cnt = (int)in.readDecimal();
        for (int i = 0; i < cnt; ++i) {
            long key = in.readDecimal();
            int value = (int)in.readDecimal();
            this.put(key, value);
        }
        return this;
    }

    public static class LongIntEntry {
        long key;
        int value;
        LongIntEntry next;

        protected LongIntEntry(long key, int value, LongIntEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new LongIntEntry(this.key, this.value, this.next == null ? null : (LongIntEntry)this.next.clone());
        }

        public long getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LongIntEntry)) {
                return false;
            }
            LongIntEntry e = (LongIntEntry)o;
            return this.key == e.getKey() && this.value == e.getValue();
        }

        public int hashCode() {
            int key1 = BitUtil.getHigh(this.key);
            int key2 = BitUtil.getLow(this.key);
            return key1 ^ key2 ^ this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class Enumer
    implements Enumeration,
    IntEnumer,
    LongEnumer {
        LongIntEntry[] table;
        int index;
        LongIntEntry entry;
        LongIntEntry lastReturned;
        byte type;

        Enumer(byte type) {
            this.table = LongIntMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.type = type;
        }

        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object nextElement() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                LongIntEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        public int nextInt() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                LongIntEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case 2: {
                        return e.value;
                    }
                }
                return LongIntMap.this.NONE;
            }
            throw new NoSuchElementException("no more next");
        }

        public long nextLong() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                LongIntEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                }
                return LongIntMap.this.NONE;
            }
            throw new NoSuchElementException("no more next");
        }
    }
}

