/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.CompareUtil;
import whatap.util.FloatEnumer;
import whatap.util.IntEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntFloatLinkedMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntFloatLinkedEntry[] table;
    private IntFloatLinkedEntry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;
    private int max;

    public IntFloatLinkedMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public IntFloatLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new IntFloatLinkedEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new IntFloatLinkedEntry(0, 0.0f, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public IntFloatLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public int[] keyArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public synchronized IntEnumer keys() {
        return new Enumer(1);
    }

    public synchronized FloatEnumer values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<IntFloatLinkedEntry> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsValue(float value) {
        IntFloatLinkedEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntFloatLinkedEntry e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.hash_next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        IntFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.hash_next;
        }
        return false;
    }

    public synchronized float get(int key) {
        IntFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized int getFirstKey() {
        return this.header.link_next.key;
    }

    public synchronized int getLastKey() {
        return this.header.link_prev.key;
    }

    public synchronized float getFirstValue() {
        return this.header.link_next.value;
    }

    public synchronized float getLastValue() {
        return this.header.link_prev.value;
    }

    private int hash(int key) {
        return key & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntFloatLinkedEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntFloatLinkedEntry[] newMap = new IntFloatLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            IntFloatLinkedEntry old = oldMap[i];
            while (old != null) {
                IntFloatLinkedEntry e = old;
                old = old.hash_next;
                int key = e.key;
                int index = this.hash(key) % newCapacity;
                e.hash_next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public IntFloatLinkedMap setMax(int max) {
        this.max = max;
        return this;
    }

    public float put(int key, float value) {
        return this._put(key, value, 4);
    }

    public float putLast(int key, float value) {
        return this._put(key, value, 2);
    }

    public float putFirst(int key, float value) {
        return this._put(key, value, 1);
    }

    private synchronized float _put(int key, float value, int m) {
        IntFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                float old = e.value;
                e.value = value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        int k = this.header.link_prev.key;
                        float v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        int k = this.header.link_next.key;
                        float v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new IntFloatLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    public float add(int key, float value) {
        return this._add(key, value, 4);
    }

    public float addLast(int key, float value) {
        return this._add(key, value, 2);
    }

    public float addFirst(int key, float value) {
        return this._add(key, value, 1);
    }

    private synchronized float _add(int key, float value, int m) {
        IntFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                float old = e.value;
                e.value += value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        this.removeLast();
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        this.removeFirst();
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new IntFloatLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    protected void overflowed(int key, float value) {
    }

    public synchronized float remove(int key) {
        IntFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntFloatLinkedEntry e = tab[index];
        IntFloatLinkedEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.hash_next = e.hash_next;
                } else {
                    tab[index] = e.hash_next;
                }
                --this.count;
                float oldValue = e.value;
                e.value = this.NONE;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized float removeFirst() {
        if (this.isEmpty()) {
            return 0.0f;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized float removeLast() {
        if (this.isEmpty()) {
            return 0.0f;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.max > 0 && this.max <= this.count;
    }

    public synchronized void clear() {
        IntFloatLinkedEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header;
        this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntFloatLinkedEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            IntFloatLinkedEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntFloatLinkedEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            IntFloatLinkedEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(IntFloatLinkedEntry link_prev, IntFloatLinkedEntry link_next, IntFloatLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(IntFloatLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    private static void print(Object e) {
        System.out.println(e);
    }

    public void toBytes(DataOutputX dout) {
        dout.writeDecimal(this.size());
        Enumeration<IntFloatLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            IntFloatLinkedEntry e = en.nextElement();
            dout.writeDecimal(e.getKey());
            dout.writeFloat(e.getValue());
        }
    }

    public IntFloatLinkedMap toObject(DataInputX in) {
        int cnt = (int)in.readDecimal();
        for (int i = 0; i < cnt; ++i) {
            int key = (int)in.readDecimal();
            float value = in.readFloat();
            this.put(key, value);
        }
        return this;
    }

    public synchronized void sort(Comparator<IntFloatLinkedEntry> c) {
        ArrayList<IntFloatLinkedEntry> list = new ArrayList<IntFloatLinkedEntry>(this.size());
        Enumeration<IntFloatLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            IntFloatLinkedEntry e = (IntFloatLinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    public static class IntFloatLinkedEntry {
        int key;
        float value;
        IntFloatLinkedEntry hash_next;
        IntFloatLinkedEntry link_next;
        IntFloatLinkedEntry link_prev;

        protected IntFloatLinkedEntry(int key, float value, IntFloatLinkedEntry next) {
            this.key = key;
            this.value = value;
            this.hash_next = next;
        }

        protected Object clone() {
            return new IntFloatLinkedEntry(this.key, this.value, this.hash_next == null ? null : (IntFloatLinkedEntry)this.hash_next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public float getValue() {
            return this.value;
        }

        public float setValue(float value) {
            float oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntFloatLinkedEntry)) {
                return false;
            }
            IntFloatLinkedEntry e = (IntFloatLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            int x = Float.floatToIntBits(this.value);
            return this.key ^ x;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration,
    FloatEnumer,
    IntEnumer {
        byte type;
        IntFloatLinkedEntry entry;

        Enumer(byte type) {
            this.entry = ((IntFloatLinkedMap)IntFloatLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entry != null && IntFloatLinkedMap.this.header != this.entry;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                IntFloatLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return Float.valueOf(e.value);
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public float nextFloat() {
            if (this.hasMoreElements()) {
                IntFloatLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 2: {
                        return e.value;
                    }
                }
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public int nextInt() {
            if (this.hasMoreElements()) {
                IntFloatLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                }
            }
            throw new NoSuchElementException("no more next");
        }
    }
}

