/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import whatap.lang.ref.LONG;
import whatap.lang.value.DecimalValue;

public class FormatUtil {
    private static char[] unit = new char[]{'b', 'k', 'm', 'g', 't', 'p'};
    static DecimalFormat fmt2 = new DecimalFormat("#,##0.0#");
    static DecimalFormat fmt1 = new DecimalFormat("#,##0.0");
    static DecimalFormat fmt0 = new DecimalFormat("#,##0");

    public static String print(Object o, String format) {
        if (o == null) {
            return "";
        }
        if (format == null) {
            return o.toString();
        }
        try {
            if (o instanceof Date) {
                return new SimpleDateFormat(format).format((Date)o);
            }
            if (o instanceof Number || o instanceof BigDecimal) {
                return new DecimalFormat(format).format(o);
            }
            if (o instanceof DecimalValue) {
                return new DecimalFormat(format).format(new Long(((DecimalValue)o).value));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return o.toString();
    }

    public static String prtMem(double mem) {
        int x = 0;
        for (x = 0; mem >= 1024.0 && x < unit.length; mem /= 1024.0, ++x) {
        }
        if (x < 2) {
            return FormatUtil.print(mem, "#,##0") + unit[x];
        }
        return FormatUtil.print(mem, "#,##0.0") + unit[x];
    }

    public static String prtNet(double mem) {
        int x = 0;
        for (x = 0; mem >= 1024.0 && x < unit.length; mem /= 1024.0, ++x) {
        }
        switch (x) {
            case 0: {
                return FormatUtil.print(mem, "#,##0");
            }
            case 1: {
                return FormatUtil.print(mem, "#,##0") + unit[x];
            }
        }
        return FormatUtil.print(mem, "#,##0.0") + unit[x];
    }

    public static String str3(long s) {
        if (s < 0L) {
            return Long.toString(s);
        }
        if (s == 0L) {
            return "000";
        }
        if (s < 10L) {
            return "00" + s;
        }
        if (s < 100L) {
            return "0" + s;
        }
        return Long.toString(s);
    }

    public static String str2(long s) {
        if (s < 0L) {
            return Long.toString(s);
        }
        if (s == 0L) {
            return "00";
        }
        if (s < 10L) {
            return "0" + s;
        }
        return Long.toString(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt2(double v) {
        DecimalFormat decimalFormat = fmt2;
        synchronized (decimalFormat) {
            return fmt2.format(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt2(double[] v) {
        StringBuffer sb = new StringBuffer();
        DecimalFormat decimalFormat = fmt2;
        synchronized (decimalFormat) {
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fmt2.format(v[i]));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt2(float v) {
        DecimalFormat decimalFormat = fmt2;
        synchronized (decimalFormat) {
            return fmt2.format(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt2(float[] v) {
        StringBuffer sb = new StringBuffer();
        DecimalFormat decimalFormat = fmt2;
        synchronized (decimalFormat) {
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fmt2.format(v[i]));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt1(double v) {
        DecimalFormat decimalFormat = fmt1;
        synchronized (decimalFormat) {
            return fmt1.format(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt1(double[] v) {
        StringBuffer sb = new StringBuffer();
        DecimalFormat decimalFormat = fmt1;
        synchronized (decimalFormat) {
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fmt1.format(v[i]));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt1(float v) {
        DecimalFormat decimalFormat = fmt1;
        synchronized (decimalFormat) {
            return fmt1.format(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt1(float[] v) {
        StringBuffer sb = new StringBuffer();
        DecimalFormat decimalFormat = fmt1;
        synchronized (decimalFormat) {
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fmt1.format(v[i]));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt0(double v) {
        DecimalFormat decimalFormat = fmt0;
        synchronized (decimalFormat) {
            return fmt0.format(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt0(float v) {
        DecimalFormat decimalFormat = fmt0;
        synchronized (decimalFormat) {
            return fmt0.format(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt0(float[] v) {
        StringBuffer sb = new StringBuffer();
        DecimalFormat decimalFormat = fmt2;
        synchronized (decimalFormat) {
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fmt0.format(v[i]));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt0(double[] v) {
        StringBuffer sb = new StringBuffer();
        DecimalFormat decimalFormat = fmt2;
        synchronized (decimalFormat) {
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fmt0.format(v[i]));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt0(int[] v) {
        StringBuffer sb = new StringBuffer();
        DecimalFormat decimalFormat = fmt2;
        synchronized (decimalFormat) {
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fmt0.format(v[i]));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt0(long[] v) {
        StringBuffer sb = new StringBuffer();
        DecimalFormat decimalFormat = fmt2;
        synchronized (decimalFormat) {
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fmt0.format(v[i]));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prt0(long v) {
        DecimalFormat decimalFormat = fmt0;
        synchronized (decimalFormat) {
            return fmt0.format(v);
        }
    }

    public static String p000(int i) {
        if (i < 10) {
            return "00" + i;
        }
        if (i < 100) {
            return "0" + i;
        }
        return Integer.toString(i);
    }

    public static String period(long time) {
        LONG ms = new LONG(time);
        int d = FormatUtil.calc(ms, 86400000L);
        int h = FormatUtil.calc(ms, 3600000L);
        int m = FormatUtil.calc(ms, 60000L);
        int s = FormatUtil.calc(ms, 1000L);
        StringBuilder sb = new StringBuilder();
        FormatUtil.fmt(sb, d, "d");
        FormatUtil.fmt(sb, h, "h");
        FormatUtil.fmt(sb, m, "m");
        FormatUtil.fmt(sb, s, "s");
        FormatUtil.fmt(sb, ms.value, "ms");
        return sb.toString();
    }

    private static void fmt(StringBuilder sb, long d, String unit) {
        if (d > 0L) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(d).append(unit);
        }
    }

    private static int calc(LONG ms, long unit) {
        int c = (int)(ms.value / unit);
        ms.value %= unit;
        return c;
    }
}

