/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.io.File;
import whatap.util.FileUtil;

public class EscapeLiteralSQL {
    static final int STAT_NORMAL = 1;
    static final int STAT_COMMENT = 2;
    static final int STAT_ALPABET = 3;
    static final int STAT_NUMBER = 4;
    static final int STAT_QUOTATION = 5;
    static final int STAT_COLON = 6;
    private String substitute = "#";
    private String substitute_num = "#";
    private boolean substitute_str_mode = false;
    private char[] chars;
    private int pos;
    private int length;
    final StringBuffer parsedSql;
    final StringBuffer param;
    private int status;
    public char sqlType;

    public EscapeLiteralSQL(String sql) {
        this.chars = sql.toCharArray();
        this.length = this.chars.length;
        this.parsedSql = new StringBuffer(this.length + 10);
        this.param = new StringBuffer();
    }

    public EscapeLiteralSQL(String sql, String subs) {
        this(sql);
        this.setSubstitute(subs);
    }

    public EscapeLiteralSQL setSubstitute(String chr) {
        this.substitute = chr;
        this.substitute_num = this.substitute_str_mode ? "'" + chr + "'" : this.substitute;
        return this;
    }

    public EscapeLiteralSQL setSubstituteStringMode(boolean b) {
        if (this.substitute_str_mode == b) {
            return this;
        }
        this.substitute_str_mode = b;
        this.substitute_num = this.substitute_str_mode ? "'" + this.substitute + "'" : this.substitute;
        return this;
    }

    public EscapeLiteralSQL process() {
        this.status = 1;
        this.pos = 0;
        while (this.pos < this.chars.length) {
            switch (this.chars[this.pos]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this._number();
                    break;
                }
                case ':': {
                    this._colon();
                    break;
                }
                case '.': {
                    this._dot();
                    break;
                }
                case '-': {
                    this._minus();
                    break;
                }
                case '/': {
                    this._slash();
                    break;
                }
                case '*': {
                    this._astar();
                    break;
                }
                case '\'': {
                    this._quotation();
                    break;
                }
                default: {
                    this._others();
                }
            }
            ++this.pos;
        }
        return this;
    }

    private void _others() {
        switch (this.status) {
            case 2: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case 3: {
                this.parsedSql.append(this.chars[this.pos]);
                if (this.isProgLetter(this.chars[this.pos])) break;
                this.status = 1;
                break;
            }
            case 4: {
                this.parsedSql.append(this.chars[this.pos]);
                this.status = 1;
                break;
            }
            case 5: {
                this.param.append(this.chars[this.pos]);
                break;
            }
            default: {
                if (this.isProgLetter(this.chars[this.pos])) {
                    this.status = 3;
                    if (this.sqlType == '\u0000') {
                        this.define_crud();
                    }
                } else {
                    this.status = 1;
                }
                this.parsedSql.append(this.chars[this.pos]);
            }
        }
    }

    public boolean isProgLetter(char ch) {
        return Character.isLetter(ch) || ch == '_' || ch == '$';
    }

    private void define_crud() {
        this.sqlType = Character.toUpperCase(this.chars[this.pos]);
        switch (this.sqlType) {
            case 'D': 
            case 'I': 
            case 'S': 
            case 'U': {
                break;
            }
            default: {
                this.sqlType = (char)42;
            }
        }
    }

    private void _colon() {
        switch (this.status) {
            case 2: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case 5: {
                this.param.append(this.chars[this.pos]);
                break;
            }
            default: {
                this.parsedSql.append(this.chars[this.pos]);
                this.status = 6;
            }
        }
    }

    private void _quotation() {
        switch (this.status) {
            case 1: 
            case 3: 
            case 4: {
                if (this.param.length() > 0) {
                    this.param.append(",");
                }
                this.param.append(this.chars[this.pos]);
                this.status = 5;
                break;
            }
            case 2: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case 5: {
                if (this.getNext(this.pos) == '\'') {
                    this.param.append(this.chars[this.pos++]);
                    this.param.append(this.chars[this.pos]);
                    break;
                }
                this.param.append("'");
                this.parsedSql.append('\'').append(this.substitute).append('\'');
                this.status = 1;
            }
        }
    }

    private void _astar() {
        switch (this.status) {
            case 2: {
                this.parsedSql.append(this.chars[this.pos]);
                if (this.getNext(this.pos) != '/') break;
                this.parsedSql.append('/');
                ++this.pos;
                this.status = 1;
                break;
            }
            case 5: {
                this.param.append(this.chars[this.pos]);
                break;
            }
            default: {
                this.parsedSql.append(this.chars[this.pos]);
                this.status = 1;
            }
        }
    }

    private void _slash() {
        switch (this.status) {
            case 2: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case 5: {
                this.param.append(this.chars[this.pos]);
                break;
            }
            default: {
                if (this.getNext(this.pos) == '*') {
                    ++this.pos;
                    this.parsedSql.append("/*");
                    this.status = 2;
                    break;
                }
                this.parsedSql.append("/");
                this.status = 1;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _minus() {
        switch (this.status) {
            case 2: {
                this.parsedSql.append(this.chars[this.pos]);
                return;
            }
            case 5: {
                this.param.append(this.chars[this.pos]);
                return;
            }
        }
        if (this.getNext(this.pos) == '-') {
            this.parsedSql.append(this.chars[this.pos]);
            while (this.chars[this.pos] != '\n') {
                ++this.pos;
                if (this.pos < this.length) {
                    this.parsedSql.append(this.chars[this.pos]);
                    continue;
                }
                break;
            }
        } else {
            this.parsedSql.append(this.chars[this.pos]);
        }
        this.status = 1;
    }

    private void _dot() {
        switch (this.status) {
            case 1: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case 2: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case 3: {
                this.parsedSql.append(this.chars[this.pos]);
                this.status = 1;
                break;
            }
            case 4: {
                this.param.append(this.chars[this.pos]);
                break;
            }
            case 5: {
                this.param.append(this.chars[this.pos]);
            }
        }
    }

    private void _number() {
        switch (this.status) {
            case 1: {
                if (this.param.length() > 0) {
                    this.param.append(",");
                }
                this.param.append(this.chars[this.pos]);
                this.parsedSql.append(this.substitute_num);
                this.status = 4;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case 4: 
            case 5: {
                this.param.append(this.chars[this.pos]);
            }
        }
    }

    private char getNext(int x) {
        return x < this.length - 1 ? this.chars[x + 1] : (char)'\u0000';
    }

    public static void main(String[] args) throws Exception {
        String s = new String(FileUtil.readAll(new File("/Users/paul/tmp1/1.sql")), "UTF8");
        long time = System.currentTimeMillis();
        EscapeLiteralSQL ec = new EscapeLiteralSQL(s, "#").process();
        long etime = System.currentTimeMillis();
        System.out.println("SQL: " + ec.parsedSql + " " + (etime - time) + " ms");
        System.out.println("PARAM: " + ec.param);
        System.out.println("type: " + ec.sqlType);
        File o = new File("/Users/paul/tmp1/1-1.sql");
        FileUtil.save(o, ec.parsedSql.toString().getBytes());
    }

    public String getParsedSql() {
        return this.parsedSql.toString();
    }

    public String getParameter() {
        return this.param.toString();
    }
}

