/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import whatap.util.CastUtil;
import whatap.util.FileUtil;
import whatap.util.IntKeyLinkedMap;
import whatap.util.IntKeyMap;
import whatap.util.StringIntMap;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    private static IntKeyLinkedMap<String> compactNames = new IntKeyLinkedMap().setMax(2000);

    public static void copy(Object src, Object dest) {
        Field[] fields = src.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (Modifier.isFinal(mod)) continue;
            fields[i].setAccessible(true);
            try {
                Object value = fields[i].get(src);
                fields[i].set(dest, value);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <V> Map<String, V> getPublicFinalNameMap(Class<?> cls, Class v) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (!fields[i].getType().equals(v) || !Modifier.isFinal(mod) || !Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            try {
                String name = fields[i].getName();
                Object value = fields[i].get(null);
                map.put(name, value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public static <V> Map<V, String> getPublicFinalValueMap(Class<?> cls, Class type) {
        HashMap<Object, String> map = new HashMap<Object, String>();
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (!fields[i].getType().equals(type) || !Modifier.isFinal(mod) || !Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            try {
                String name = fields[i].getName();
                Object value = fields[i].get(null);
                map.put(value, name);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public static IntKeyMap<String> getConstantValueMap(Class<?> cls, Class type) {
        IntKeyMap<String> map = new IntKeyMap<String>();
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (!fields[i].getType().equals(type) || !Modifier.isFinal(mod) || !Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            try {
                String name = fields[i].getName();
                Object value = fields[i].get(null);
                map.put(CastUtil.cint(value), name);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public static StringIntMap getConstantKeyMap(Class<?> cls, Class type) {
        StringIntMap map = new StringIntMap();
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (!fields[i].getType().equals(type) || !Modifier.isFinal(mod) || !Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            try {
                String name = fields[i].getName();
                Object value = fields[i].get(null);
                map.put(name, CastUtil.cint(value));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public static String getClassDescription(Class c1, boolean isAll) {
        Method[] m;
        int x = c1.getName().lastIndexOf(".");
        StringBuffer sb = new StringBuffer();
        if (x > 0) {
            sb.append("package ").append(c1.getName().substring(0, x)).append(";\n\n");
        }
        int acc = c1.getModifiers();
        ClassUtil.mod(sb, acc, c1.isInterface());
        if (c1.isInterface()) {
            sb.append("interface ");
        } else {
            sb.append("class ");
        }
        if (x > 0) {
            sb.append(c1.getName().substring(x + 1));
        } else {
            sb.append(c1.getName());
        }
        if (c1.getSuperclass() != null && c1.getSuperclass() != Object.class) {
            sb.append(" extends ").append(c1.getSuperclass().getName());
        }
        Class<?>[] inf = c1.getInterfaces();
        for (int i = 0; i < inf.length; ++i) {
            if (i == 0) {
                sb.append(" implements ");
            }
            if (i > 0) {
                sb.append(",");
            }
            sb.append(inf[i].getName());
        }
        sb.append("{\n");
        Field[] f = isAll ? c1.getFields() : c1.getDeclaredFields();
        for (int i = 0; i < f.length; ++i) {
            sb.append("\t");
            ClassUtil.mod(sb, f[i].getModifiers(), c1.isInterface());
            sb.append(ClassUtil.toClassString(f[i].getType())).append(" ");
            sb.append(f[i].getName()).append(";\n");
        }
        Method[] methodArray = m = isAll ? c1.getMethods() : c1.getDeclaredMethods();
        if (f.length > 0 && m.length > 0) {
            sb.append("\n");
        }
        for (int i = 0; i < m.length; ++i) {
            sb.append("\t");
            ClassUtil.mod(sb, m[i].getModifiers(), c1.isInterface());
            sb.append(ClassUtil.toClassString(m[i].getReturnType())).append(" ");
            sb.append(m[i].getName());
            sb.append("(");
            Class<?>[] pc = m[i].getParameterTypes();
            for (int p = 0; p < pc.length; ++p) {
                if (p > 0) {
                    sb.append(",");
                }
                sb.append(ClassUtil.toClassString(pc[p])).append(" a" + p);
            }
            sb.append(")");
            if (!Modifier.isAbstract(m[i].getModifiers())) {
                sb.append("{...}\n");
                continue;
            }
            sb.append(";\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static void mod(StringBuffer sb, int acc, boolean isInterface) {
        if (Modifier.isAbstract(acc) && !isInterface) {
            sb.append("abstract ");
        }
        if (Modifier.isProtected(acc)) {
            sb.append("protected ");
        }
        if (Modifier.isPrivate(acc)) {
            sb.append("private ");
        }
        if (Modifier.isPublic(acc)) {
            sb.append("public ");
        }
        if (Modifier.isFinal(acc)) {
            sb.append("final ");
        }
        if (Modifier.isSynchronized(acc)) {
            sb.append("synchronized ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteCode(Class c) {
        if (c == null) {
            return null;
        }
        String clsAsResource = "/" + c.getName().replace('.', '/').concat(".class");
        InputStream in = null;
        try {
            in = c.getResourceAsStream(clsAsResource);
            if (in == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            int n = 0;
            while ((n = in.read(buff, 0, 1024)) >= 0) {
                out.write(buff, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
        }
        finally {
            FileUtil.close(in);
        }
        return null;
    }

    public static String getCompactName(Object o) {
        return ClassUtil.getCompactName(o.getClass());
    }

    public static String getCompactName(Class<? extends Object> class1) {
        String compact = compactNames.get(class1.hashCode());
        if (compact != null) {
            return compact;
        }
        String[] nameArr = StringUtil.split(class1.getName(), '.');
        switch (nameArr.length) {
            case 0: {
                compact = "";
                break;
            }
            case 1: {
                compact = nameArr[0];
                break;
            }
            case 2: {
                compact = nameArr[0].substring(0, 1) + "." + nameArr[1];
                break;
            }
            default: {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < nameArr.length - 1; ++i) {
                    sb.append(nameArr[i].substring(0, 1));
                    sb.append('.');
                }
                sb.append(nameArr[nameArr.length - 1]);
                compact = sb.toString();
            }
        }
        compactNames.put(class1.hashCode(), compact);
        return compact;
    }

    public static String wrapper(Class c1, String packageName, String postfix) {
        String cr = "\n";
        String tab = "   ";
        String className = c1.getSimpleName() + postfix;
        StringBuffer sb = new StringBuffer();
        sb.append("package ").append(packageName).append(";\n\n");
        sb.append("public class ").append(className);
        if (!c1.isInterface()) {
            sb.append(" extends ").append(c1.getName());
        } else {
            sb.append(" implements ").append(c1.getName());
        }
        sb.append("{" + cr);
        sb.append(cr + tab);
        sb.append("protected ").append(c1.getName()).append(" inner; ");
        sb.append(cr);
        Method[] m = c1.getMethods();
        sb.append(cr);
        sb.append(tab);
        sb.append("public " + className).append("(").append(c1.getName()).append(" o){" + cr);
        sb.append(tab + tab + "this.inner=o;" + cr);
        sb.append(tab + "}" + cr);
        for (int i = 0; i < m.length; ++i) {
            int p;
            if (!c1.isInterface() && !Modifier.isPublic(m[i].getModifiers())) continue;
            sb.append(tab);
            ClassUtil.mod(sb, m[i].getModifiers(), c1.isInterface());
            sb.append(ClassUtil.toClassString(m[i].getReturnType())).append(" ");
            sb.append(m[i].getName());
            sb.append("(");
            Class<?>[] pc = m[i].getParameterTypes();
            for (int p2 = 0; p2 < pc.length; ++p2) {
                if (p2 > 0) {
                    sb.append(",");
                }
                sb.append(ClassUtil.toClassString(pc[p2])).append(" a" + p2);
            }
            sb.append(")");
            Class<?>[] ex = m[i].getExceptionTypes();
            if (ex != null && ex.length > 0) {
                sb.append(" throws ");
                for (p = 0; p < ex.length; ++p) {
                    if (p > 0) {
                        sb.append(",");
                    }
                    sb.append(ClassUtil.toClassString(ex[p]));
                }
            }
            sb.append("{" + cr);
            sb.append(tab + tab);
            if (!ClassUtil.toClassString(m[i].getReturnType()).equals("void")) {
                sb.append("return ");
            }
            sb.append(" this.inner." + m[i].getName() + "(");
            for (p = 0; p < pc.length; ++p) {
                if (p > 0) {
                    sb.append(",");
                }
                sb.append("a" + p);
            }
            sb.append(");" + cr);
            sb.append(tab + "}" + cr);
        }
        sb.append("}");
        return sb.toString();
    }

    public static String toClassString(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return ClassUtil.toClassString(clazz.getComponentType()) + "[]";
        }
        if (clazz == Boolean.TYPE) {
            return "boolean";
        }
        if (clazz == Byte.TYPE) {
            return "byte";
        }
        if (clazz == Short.TYPE) {
            return "short";
        }
        if (clazz == Integer.TYPE) {
            return "int";
        }
        if (clazz == Long.TYPE) {
            return "long";
        }
        if (clazz == Float.TYPE) {
            return "float";
        }
        if (clazz == Double.TYPE) {
            return "double";
        }
        if (clazz == Character.TYPE) {
            return "char";
        }
        String name = clazz.getName();
        if (name.startsWith("java.lang")) {
            return name.substring("java.lang".length() + 1);
        }
        return name;
    }
}

