/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.sys;

import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfPerfX;
import whatap.lang.pack.TagCountPack;
import whatap.perfx.sys.linux.LinuxDiskIO;
import whatap.perfx.sys.linux.LinuxDiskInodeUsage;
import whatap.perfx.sys.linux.LinuxDiskList;
import whatap.perfx.sys.linux.tcp.TcpStateCounter;
import whatap.perfx.sys.mac.tcp.TcpStateOSXCounter;
import whatap.perfx.sys.win.WinDiskIO;
import whatap.util.IPUtil;
import whatap.util.StringLinkedSet;
import whatap.util.SysJMX;
import whatap.util.SystemUtil;
import whatap.util.ThreadUtil;

public class PerfXSystem
extends Thread {
    private static PerfXSystem instance;
    public String host;
    Configure conf;

    public PerfXSystem() {
        this.host = IPUtil.toString(SecurityMaster.getInstance().IP);
        this.conf = Configure.getInstance();
    }

    public static final synchronized PerfXSystem getInstance() {
        if (instance == null) {
            instance = new PerfXSystem();
            instance.setName("WhaTap-PerfXSystem");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void run() {
        while (true) {
            if (!ConfPerfX.perfx_system_enabled) {
                ThreadUtil.sleep(10000L);
                continue;
            }
            ThreadUtil.sleep(ConfPerfX.perfx_system_interval);
            try {
                if ("0.0.0.0".equals(this.host)) {
                    this.host = IPUtil.toString(SecurityMaster.getInstance().IP);
                }
                this.process();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void process() {
        if (this.conf.getBoolean("perfx_system_disk_io_enabled", false)) {
            if (SystemUtil.IS_LINUX) {
                StringLinkedSet disks = LinuxDiskList.getDisks();
                if (disks.size() > 0) {
                    LinuxDiskIO.send(disks);
                }
            } else if (SystemUtil.IS_WINDOWS) {
                WinDiskIO.send();
            }
        }
        if (this.conf.getBoolean("perfx_system_disk_inode_enabled", false) && SystemUtil.IS_LINUX) {
            LinuxDiskInodeUsage.send();
        }
        if (this.conf.getBoolean("perfx_system_tcp4count_enabled", false)) {
            if (SystemUtil.IS_LINUX) {
                TcpStateCounter.tcp();
            } else if (SystemUtil.IS_MAC) {
                TcpStateOSXCounter.tcp4();
            }
        }
        if (this.conf.getBoolean("perfx_system_tcp6count_enabled", false)) {
            if (SystemUtil.IS_LINUX) {
                TcpStateCounter.tcp6();
            } else if (SystemUtil.IS_MAC) {
                TcpStateOSXCounter.tcp6();
            }
        }
    }

    public static void setTagAgentInfo(TagCountPack p) {
        SecurityMaster secu = SecurityMaster.getInstance();
        p.putTag("oname", secu.ONAME);
        p.putTag("host_ip", PerfXSystem.getInstance().host);
        p.putTag("pid", SysJMX.getProcessPID());
    }
}

