/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.java;

import java.lang.management.ManagementFactory;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.perfx.java.PerfXJava;
import whatap.perfx.plugin.PerfXUtil;
import whatap.util.DateUtil;
import whatap.util.SystemUtil;

public class PerfXOperatingSystemAction {
    public MBeanServer mserver;
    ObjectName obj;
    long last_checked = 0L;
    MBeanAttributeInfo[] attrs;
    Configure conf = Configure.getInstance();

    public void process() {
        if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
            return;
        }
        if (this.conf.tagcount_subset_v1_enabled) {
            this.v1();
        }
        if (this.conf.tagcount_subset_v2_enabled) {
            this.v2();
        }
    }

    private void v1() {
        try {
            if (this.mserver == null) {
                this.mserver = ManagementFactory.getPlatformMBeanServer();
            }
            if (this.obj == null) {
                this.obj = new ObjectName("java.lang:type=OperatingSystem");
            }
            if (this.obj == null) {
                return;
            }
            TagCountPack p = new TagCountPack();
            p.time = DateUtil.currentTime() / 1000L * 1000L;
            p.category = "java_os";
            PerfXJava.setTagAgentInfo(p);
            if (this.attrs == null) {
                this.attrs = this.mserver.getMBeanInfo(this.obj).getAttributes();
            }
            for (MBeanAttributeInfo m : this.attrs) {
                String name = m.getName();
                Object value = this.mserver.getAttribute(this.obj, name);
                PerfXUtil.setAttr(p, name, value);
            }
            DataPackSender.send(p);
        }
        catch (Throwable e) {
            Logger.println(e.toString());
        }
    }

    private void v2() {
        try {
            if (this.mserver == null) {
                this.mserver = ManagementFactory.getPlatformMBeanServer();
            }
            if (this.obj == null) {
                this.obj = new ObjectName("java.lang:type=OperatingSystem");
            }
            if (this.obj == null) {
                return;
            }
            TagCountPack p = new TagCountPack();
            p.time = DateUtil.currentTime() / 1000L * 1000L;
            p.category = "javax_os";
            p.tags.put("!rectype", 1);
            PerfXJava.setTagAgentInfo(p);
            if (this.attrs == null) {
                this.attrs = this.mserver.getMBeanInfo(this.obj).getAttributes();
            }
            for (MBeanAttributeInfo m : this.attrs) {
                String name = m.getName();
                Object value = this.mserver.getAttribute(this.obj, name);
                PerfXUtil.setAttr(p, name, value);
            }
            DataPackSender.send(p);
        }
        catch (Exception e) {
            Logger.println(e.toString());
        }
    }
}

