/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.java;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.ListValue;
import whatap.perfx.java.IAction;
import whatap.perfx.java.PerfXJava;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.SysJMX;
import whatap.util.SystemUtil;

public class PerfXGCAction
extends IAction {
    Configure conf = Configure.getInstance();

    public void process() {
        try {
            if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
                return;
            }
            if (this.conf.tagcount_subset_v2_enabled) {
                this.javax_memory_gc();
            }
            if (this.conf.tagcount_subset_v1_enabled) {
                this.orgin();
            }
        }
        catch (Throwable e) {
            Logger.println(e.toString());
        }
    }

    private void javax_memory_gc() {
        TagCountPack p = new TagCountPack();
        p.time = DateUtil.currentTime() / 1000L * 1000L;
        p.category = "javax_memory_gc";
        p.putTag("oname", SecurityMaster.getInstance().ONAME);
        p.putTag("host_ip", PerfXJava.getInstance().host);
        p.putTag("pid", SysJMX.getProcessPID());
        p.tags.put("!rectype", 2);
        ListValue idLv = p.fields.internList("@id");
        ListValue nameLv = p.fields.internList("name");
        ListValue countLv = p.fields.internList("CollectionCount");
        ListValue timeLv = p.fields.internList("CollectionTime");
        List<GarbageCollectorMXBean> mbs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean mb : mbs) {
            String name = mb.getName();
            idLv.add(HashUtil.hash(name));
            nameLv.add(name);
            countLv.add(mb.getCollectionCount());
            timeLv.add(mb.getCollectionTime());
        }
        DataPackSender.send(p, false);
    }

    private void orgin() {
        List<GarbageCollectorMXBean> mbs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean mb : mbs) {
            TagCountPack p = new TagCountPack();
            p.time = DateUtil.currentTime() / 1000L * 1000L;
            p.category = "java_gc";
            p.putTag("name", mb.getName());
            p.putTag("oname", SecurityMaster.getInstance().ONAME);
            p.putTag("host_ip", PerfXJava.getInstance().host);
            p.putTag("pid", SysJMX.getProcessPID());
            p.put("CollectionCount", new DecimalValue(mb.getCollectionCount()));
            p.put("CollectionTime", new DecimalValue(mb.getCollectionTime()));
            DataPackSender.send(p, false);
        }
    }
}

